<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\BannerGroups;

/**
 * Class BannerGroupsAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerGroupsAdmin extends AdminMnv
{

	public function fetch()
    {
        $groupBanners = new BannerGroups();

        $this->smarty->assign('activeItem','bannergroups');
        $this->smarty->assign('title', 'Группы баннеров');

        $groupBanners->groupId  = getRequestVar('id', '');
        $groupIds = getRequestVar('group', '', true);

        if ($this->action == 'remove') {

            if ($groupBanners->remove()) {
                response()->make("deleteSuccess('". $groupBanners->groupId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;

        } else if ($this->action == 'status') {

            $result = $groupBanners->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        } else if ($this->action == 'reorder') {

            $groupBanners->reorder($groupIds);

        }


        $groupBanners->listBanners();
        if ($groupBanners->groups) {
            foreach ($groupBanners->groups as $groupId => $group) {
                $groupBanners->groups[$groupId]['statusName'] = lang('general:statuses:' . $group['status']);
                $pages = explode(',', $group['pages']);
                foreach ($pages as $page) {
                    $groupBanners->groups[$groupId]['pageNames'][$page] = $groupBanners->getPageName($page);
                }
            }
        }

        $pages = getPageNums($groupBanners->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $groupBanners->total);
        $this->smarty->assign('groups', $groupBanners->groups);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('bannergroups')) {
            return $this->smarty->fetch('banner-groups.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}