<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\BannerGroups;
use Mnv\Models\BannerImages;

/**
 * Class BannerImageAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerImageAdmin extends AdminMnv
{

	public function fetch()
    {
        $banners = new BannerImages();
        $groups = new BannerGroups();

        $this->smarty->assign('activeItem','bannerimages');
        $this->smarty->assign('title', 'Слайд');

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $this->smarty->assign('groups', $groups->getGroups());


        $banners->banner   = getRequestVar('banner', '',  true);
        $banners->bannerId = (int) getRequestVar('id');
        $image    = getRequestVar('image', '',  true);
        $imageId = (int) getRequestVar('imageId');

        if ($this->action == 'add' || $this->action == 'edit') {
            $banners->edit();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($banners->banner['title'])) {
                $this->errors['title'] = true;
            }
            if (empty($banners->banner['groupId'])) {
                $this->errors['group'] = true;
            }
            if (!empty($image)) {
                $banners->banner['fileId'] = $image['fileId'];
            }

            if (empty($this->errors)) {
                if (empty($banners->bannerId)) {
                    if ($banners->add($banners->banner)) {
                        $this->messages['saved'] = true;
                        Logger::init()->info("Добавлен новый банер «" . $banners->banner['title'] . "»", $this->manager)->save();
                    } else {
                        $this->errors['not_saved'] = true;
                    }


                    if (empty($this->errors) && $this->action === 'apply') {
                        redirect($this->adminUrl . "/bannerimage?" . $this->buildQueryString([
                                'action'=> 'edit',
                                'id'    => $banners->bannerId,
                                'page'  => $this->page
                            ]));
                    }
                } else {
                    $banners->update($banners->banner);
                    $this->messages['saved'] = true;
                    Logger::init()->info("Банер «" . $banners->banner['title'] . "» отредактирован", $this->manager)->save();
//                    if ($banners->update($banners->banner)) {
//                        $this->messages['saved'] = true;
//
//                    } else {
//                        $this->errors['not_saved'] = true;
//                    }
                }

                $banners->edit();

                if (empty($this->errors) && $this->action == 'save') {
                    redirect($this->adminUrl . "/bannerimages?" . $this->buildQueryString(['page' => $this->page]));
                }

            } else {
                $this->smarty->assign('action', 'edit');
            }
        } else if ($this->action == 'deleteImage') {

            $result = $banners->deleteImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $this->smarty->assign('banner',  $banners->banner);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if (Managers::init()->permissions('bannerimages')) {
            return $this->smarty->fetch('banner-image.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}