<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\BannerImages;

/**
 * Class BannerImagesAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerImagesAdmin extends AdminMnv
{

	public function fetch()
    {
        $banners = new BannerImages();

        $this->smarty->assign('activeItem','bannerimages');
        $this->smarty->assign('title', lang('sliders:title'));

        $banners->bannerId  = (int) getRequestVar('id', '');
        $bannerIds = getRequestVar('banner', '', true);

        if ($this->action == 'remove') {

            if ($banners->remove()) {
                Logger::init()->info("Слайд « ID-" . $banners->bannerId . "» удален.", $this->manager)->save();
                response()->make("deleteSuccess('". $banners->bannerId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        }
        else if ($this->action == 'status') {

            $result = $banners->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'reorder') {
            $banners->reorder($bannerIds);
        }


        $banners->getAll();
        if (!empty($banners->banners)) {
            foreach ($banners->banners as $bannerId => $banner) {
                $banners->banners[$bannerId]['statusName'] = lang('general:statuses:' . $banner['status']);
                $banners->banners[$bannerId]['groupName'] = $banners->getGroupName($banner['groupId']);
                if (!empty($banner['fileId']) && $banner['fileId'] > 0) {
                    $banners->banners[$bannerId]['image'] = $banners->get_image($banner['fileId']);
                }
            }
        }

        $pages = getPageNums($banners->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $banners->total);
        $this->smarty->assign('banners',  $banners->banners);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('bannerimages')) {
            return $this->smarty->fetch('banner-images.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}