<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Models\Blocks\Blocks;

/**
 * Class BlockAdmin
 * @package Mnv\Admin\Controllers
 */
class BlockAdmin extends AdminMnv
{

    /**
     * Вывод всего контента
     */
    public function fetch()
    {

        $blocks = new Blocks();

        /** title */
        $this->smarty->assign('title', ' Информационные блоки');
        /** activeItem */
        $this->smarty->assign('activeItem', 'blocks');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('typeBlocks', array('0' => 'Выберите блок', '1' => 'Блок 1', '2' => 'Блок 2', '3' => 'Блок 3', '4' => 'Блок 4'));

        /** получение ID для редактирования / удаления / изменение статуса */
        $blocks->blockId     = (int) getRequestVar('id', '');
        $blocks->block       = getRequestVar('block', '', true);

        $sections = Helpers::init()->getSectionContent(0, null );
        if (count($sections) < 2) {
            $this->errors['no_sections'] = true;
        }
        $this->smarty->assign('sections', $sections);


        if ($this->action == 'add' || $this->action == 'edit') {
            $blocks->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($blocks->block['title'])) {
                $this->errors['title'] = true;
            }

            /** проверка доступных разделов для статей */
            if (empty($blocks->block['sectionId']) || empty($sections[$blocks->block['sectionId']])) {
                $this->errors['sectionId'] = true;
            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($blocks->blockId)) {

                   if ($blocks->add($blocks->block)) {
                        $this->messages['saved'] = true;

                       if (empty($this->errors) && $this->action === 'apply') {
                           redirect($this->adminUrl . "/block?" . $this->buildQueryString([
                                   'action'=> 'edit',
                                   'id'    => $blocks->blockId,
                                   'page'  => $this->page
                               ]));
                       }

                    } else {
                        $this->errors['not_saved'] = true;
                    }

                } else {
                        $blocks->update($blocks->block);
                        $this->messages['saved'] = true;
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $this->smarty->assign('action', 'edit');
            }

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/blocks?" . $this->buildQueryString(['page' => $this->page]));
            }

        }

        $this->smarty->assign('block', $blocks->block);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('blocks')) {
            return $this->smarty->fetch('block.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}