<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}
;
use Mnv\Core\Managers;
use Mnv\Models\Coupons;
use Mnv\Models\Currencies;

/**
 * Class CouponsAdmin
 * @package Mnv\Admin\Controllers
 */
class CouponsAdmin extends Coupons
{

    /**
     * Получение всех слайдов
     * @return string
     * @throws \SmartyException
     */
	public function fetch()
    {
        $currency = new Currencies();

        $this->smarty->assign('activeItem','coupons');
        $this->smarty->assign('title', 'Купоны');
        $this->smarty->assign('defaultCurrency', $currency->getDefaultCurrency()->codeName);

        $this->couponId  = (int)getRequestVar('id', '');
        $this->coupon  = getRequestVar('coupon', '', true);

        if ($this->action == 'apply') {
            if (empty($this->coupon['code'])) {
                $this->errors['code'] = true;
            }
            if (empty($this->coupon['value'])) {
                $this->errors['value'] = true;
            }
            if (empty($this->coupon['min_order_price'])) {
                unset($this->coupon['min_order_price']);
            }
            if (empty($this->coupon['expire'])) {
                unset($this->coupon['expire']);
            }

            $result = array('status' => 400, 'message' => $this->errors);
            if (empty($this->errors)) {
                if ($this->add($this->coupon)) {
                    $this->messages['saved'] = true;
                    $result = array('status' => 200, 'message' => $this->messages);
                } else {
                    $this->errors['not_saved'] = true;
                    $result = array('status' => 400, 'message' => $this->errors);
                }
            }

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        } else if ($this->action == 'remove') {

            if ($this->remove()) {
                response()->make("deleteSuccess('". $this->couponId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'status') {

            $result = $this->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }

        $this->getAll();
        if (!empty($this->coupons)) {
            foreach ($this->coupons as &$coupon) {
                if (!is_null($coupon->expire)) {
                    $coupon->expire = langDate(adjustTime($coupon->expire, false, 'd.m.Y'));
                }
            }
        }

        $pages = getPageNums($this->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalCoupons', $this->total);
        $this->smarty->assign('coupons',  $this->coupons);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('coupons')) {
            return $this->smarty->fetch('coupons.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}