<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Currencies;

/**
 * Class CurrenciesAdmin
 * @package Mnv\Admin\Controllers
 */
class CurrenciesAdmin extends AdminMnv
{

    public function fetch()
    {
        $currencies = new Currencies();

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));

        $currencies->currencyId = (int) getRequestVar('id');
        $currencyIds            = getRequestVar('currency', '', true);


        if ($this->action == 'remove') {
            if ($currencies->remove()) {
                if (!saveSerializations()) {
                    $this->errors['serializations'] = true;
                }

                response()->make("deleteSuccess('". $currencies->currencyId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
                exit;
            }
        } else if ($this->action == 'reorder') {
            $currencies->reorder($currencyIds);

        } else if (($this->action == 'setDefaulrCurrency') && $currencies->setDefaultCurrency() && !saveSerializations()) {
            $this->errors['serializations'] = true;
        }


        $currencies->getAll();
        $this->smarty->assign('currencyList', $currencies->currencies);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('currencies')) {
            return $this->smarty->fetch('currencies.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


    



