<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Currencies;

/**
 * Class CurrencyAdmin
 * @package Mnv\Admin\Controllers
 */
class CurrencyAdmin extends AdminMnv
{

    public function fetch()
    {

        $currencies = new Currencies();

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));

        $currencies->currency = getRequestVar('currency', '', true);
        $currencies->currencyId = (int)getRequestVar('id');

        if ($this->action == 'add' || $this->action == 'edit') {
            $currencies->edit();
        } else if ($this->action == 'save') {

            if (empty($currencies->currency['title'])) {
                $this->errors['titleNull'] = true;
            }
            if (empty($currencies->currency['codeName'])) {
                $this->errors['codeNameNull'] = true;
            }
            if (empty($currencies->currency['course'])) {
                $this->errors['course'] = true;
            }

            if (empty($this->errors)) {
                if (empty($currencies->currencyId)) {
                    $currencies->add($currencies->currency);
                } else {
                    $currencies->update($currencies->currency);
                }
                // Save serializations
                if (!saveSerializations()) {
                    $this->errors['serializations'] = true;
                }

                redirect($this->adminUrl .  '/currencies');
            }
        }

        $this->smarty->assign('currency', $currencies->currency);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('currencies')) {
            return $this->smarty->fetch('currency.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


    



