<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\FAQ;

/**
 * Class FAQsAdmin
 * @package Mnv\Admin\Controllers
 */
class FAQsAdmin extends FAQ
{

	public function fetch()
    {

        $this->smarty->assign('activeItem','faqs');
        $this->smarty->assign('title', 'FAQ');

        $this->faqId  = (int) getRequestVar('id', '');
        $faqIds       = getRequestVar('faq', '', true);

        if ($this->action == 'remove') {
            if ($this->remove()) {
                response()->make("deleteSuccess('". $this->faqId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        } else if ($this->action == 'status') {
            $result = $this->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        } else if ($this->action == 'reorder') {
            $this->reorder($faqIds);
        }


        $this->getAll();
        if (!empty($this->faqs)) {
            foreach ($this->faqs as $faqId => $faq) {
                $this->faqs[$faqId]['statusName'] = lang('general:statuses:' . $faq['status']);
            }
        }

        $pages = getPageNums($this->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalFaqs', $this->total);
        $this->smarty->assign('faqs',  $this->faqs);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('faqs')) {
            return $this->smarty->fetch('faqs.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}