<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Models\Features;

/**
 * Class FeaturesAdmin
 * @package Mnv\Admin\Controllers
 */
class FeaturesAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $feature = new Features();
        $sectionIds = [];

        $this->smarty->assign('activeItem','features');
        $this->smarty->assign('title', 'Свойства товара');

        /** получение ID для удаления / изменение статуса / удаление и обновление основной картинки */
        $feature->featureId     = (int) getRequestVar('id', '');
        $featureIds    = getRequestVar('feature', '', true);

        /** получение разделов по типу контента */
        $sections = Helpers::init()->getSectionContent(0, 'products');

//        print_r($sections);

        /** действия */
        if ($this->action === 'remove') {
            $feature->remove($feature->featureId);
            response()->make("deleteSuccess('" . $feature->featureId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
        }
        else if ($this->action === 'reorder') {
            $feature->reorder($featureIds);
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        else if ($this->action === 'status') {
           $result = $feature->status();
           response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
           exit;
        }


        if (!empty($this->filterSection) && !empty($SECTIONS[$this->filterSection])) {
            $sectionIds = array($this->filterSection);
            if (!empty($SECTIONS[$this->filterSection]['allChildren'])) {
                $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filterSection]['allChildren']);
            }
        }

        /** фильтровать контент */
        $filter = array_filter([
            'query'         => $this->query,
            'status'        => $this->status,
            'sectionIds'    => $sectionIds,
        ]);

        /** получение всех статей */
        $feature->getAll($filter, 'orderBy ASC');
        foreach ($feature->features as $featureId => $feat) {
            $feature->features[$featureId]['statusName'] = lang('general:statuses:'.$feat['status']);
            if (!empty($feat['sectionIds'])) {
                $sectionIds = json_decode($feat['sectionIds'], false, 512, JSON_THROW_ON_ERROR);
                $sectionArr = array();
                foreach ($sectionIds as $key => $sectionId) {
                    $sectionArr[$key] = isset($SECTIONS[$sectionId]) ? $SECTIONS[$sectionId]['name'] : '';
                }
                $feature->features[$featureId]['sections'] = $sectionArr;
            }
            $feature->features[$featureId]['isFilter'] = ($feat['isFilter'] == 1) ? "Да" : "Нет";
        }

        /** pagination */
        $pages = getPageNums($feature->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('totalArticles', $feature->total);
        $this->smarty->assign('features', $feature->features);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('sections', $sections);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('features')) {
            return $this->smarty->fetch('features.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}