<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Feedbacks;

/**
 * Class FeedbacksAdmin
 * @package Mnv\Admin\Controllers
 */
class FeedbacksAdmin extends AdminMnv
{

    public function fetch()
    {
        $feedbacks = new Feedbacks();

        $this->smarty->assign('activeItem','feedbacks');
        $this->smarty->assign('title', 'Центр сообщений');

        $type          = getRequestVar('type', '');
        $date          = getRequestVar('date', '');
        $feedbacks->id = (int) getRequestVar('id', 0);
        $feedback      = (object) getRequestVar('feedback', '', true);
        $feedbackIds   = getRequestVar('feedbackIds', '',  true);


        /* table list */
        $this->page         = getRequestVar('start', 0);
        $this->limit        = getRequestVar('length', 10);

        $draw               = getRequestVar('draw', 1);
        $search	            = getRequestVar('search', '');     // $_POST['search']['value'];
        $columnName         = getRequestVar('columns');                 // $_POST['columns'][$columnIndex]['data'];
        $columnSortOrder    = getRequestVar('order');                   // $_POST['order'][0]['dir'];
        /* end table list */


        if ($this->action == 'remove') {
            if ($feedbacks->remove($feedbacks->id)) {
                echo "removeElement(" . $feedbacks->id . ", 'mail');\r\n";
                echo "deleteMessage();\r\n";
            } else {
                echo "notDeleteFound()";
            }
            exit;
        } else if ($this->action == 'approve') {
//            if ($feedbacks->approve($feedbacks->id)) {
//                echo "document.getElementById('status-$feedbacks->id').innerHTML = 'АКТИВЕН';\r\n";
//                echo  "document.getElementById('user-approve-$feedbacks->id').style.display = 'none';\r\n";
//            } else {
//                echo "writeStatus('" . lang('users:errors:13') . "', 'aError');\r\n";
//                echo "window.setTimeout(\"writeStatus('')\", 5000);\r\n";
//            }
//            exit;
        } else if ($this->action == 'table') {

            /** получение всех менеджеров */
            $feedbacks->getAll($search['value'], $this->status, $this->page, $this->limit, $columnSortOrder, $columnName);

            /** получение кол-во менеджеров */
            $feedbacks->total($search['value'], $this->status);

            /** получение кол-во менеджеров при фильтрации */
            $feedbacks->countTableFiltered($search['value']);

            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => intval($feedbacks->total),
                "recordsFiltered"   => intval($feedbacks->totalFiltered),
                "data"              => $feedbacks->mails
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }


        $this->smarty->assign('page', $this->page);


        $feedbackArr = $feedbacks->getAllFeedback($type, $date, $this->page, $this->limit);

        $totalFeedback = $feedbacks->totalCount($type, $date);

        $pages = getPageNums($totalFeedback, $this->page, $this->limit, 0, 4, 4, 0 );

        $this->smarty->assign( 'totalFeedback', $totalFeedback);
        $this->smarty->assign( 'feedback', $feedbackArr);
        $this->smarty->assign( 'pageNums', $pages );

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('feedbacks')) {
            return $this->smarty->fetch('feedbacks.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}