<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Files\FileManager;
use League\Flysystem\FilesystemException;
use Mnv\Core\Managers;

/**
 * Class FileManagerAdmin
 * @package Mnv\Admin\Controllers
 */
class FileManagerAdmin extends AdminMnv
{

    public function fetch()
    {
        $response = array();

        $this->smarty->assign('activeItem', 'filemanager');
        $this->smarty->assign('title', lang('fileManager:title'));

        $downloadableFile   = getRequestFiles();
        $action = getRequestVar('action','');
        $file   = getRequestVar('file', '', true);
        $path   = getRequestVar('path', '', true);
        $folder = getRequestVar('folder');

        $realPath = realpath(GLOBAL_ROOT.$path).DIRECTORY_SEPARATOR;
        if (strpos($realPath, GLOBAL_ROOT) === false) $realPath = GLOBAL_ROOT.DIRECTORY_SEPARATOR;
        $path = str_replace(GLOBAL_ROOT, '', $realPath);

        if ($path != DIRECTORY_SEPARATOR) {
            $upPath = realpath($realPath.'/../').DIRECTORY_SEPARATOR;
            $upPath = str_replace(GLOBAL_ROOT, '', $upPath);
        } else {
            $upPath = $path;
        }

        $fileManager = new FileManager(GLOBAL_ROOT);

        $this->smarty->assign('path', $path);
        $this->smarty->assign('upPath', $upPath);

        /** загрузка нового файла */
        if ($action == 'upload') {

            if (preg_match('/[^0-9a-zA-Z\-_\. ]/i', $downloadableFile['file']['name'])) {
                $this->errors['fileNameCharacters'] = true;
                $response = array('status' => 400, 'message' => lang('fileManager:errors:5'));
            }
            if (empty($this->errors)) {
                $stream = fopen($downloadableFile['file']['tmp_name'], 'r+');
                try {
                    $fileManager->filesystem->writeStream($path . $downloadableFile['file']['name'], $stream);
                    $response = array('status' => 200, 'message' => lang('fileManager:messages:1'));
                } catch (FilesystemException $e) {
                    $response = array('status' => 500, 'message' => lang('fileManager:errors:0'), 'error' => $e->getMessage());
                }
                if (is_resource($stream)) {
                    fclose($stream);
                }
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }

        /** добавление директории */
        else if ($action == 'add_folder') {

            if (preg_match('/[^0-9a-zA-Z\-_\. ]/i', $folder['name'])) $this->errors['fileNameCharacters'] = true;
            if (empty($this->errors)) {
                try {
                    $fileManager->filesystem->createDirectory($path . $folder['name']);
                    $this->messages['folder'] = true;
                } catch (\League\Flysystem\FilesystemException $e) {
                    $this->errors['folder'] = true;
                }
            }

        }

        /** удаление файла / директории */
        else if ($action == 'remove') {

            if ($fileManager->filesystem->fileExists($path . $file['name'])) {
                try {
                    $fileManager->filesystem->delete($path . $file['name']);
                    $this->messages['deletedFile'] = true;
                } catch (\League\Flysystem\FilesystemException $e) {
                    $this->errors['deleteFile'] = true;
                }
            } else {
                try {
                    $fileManager->filesystem->deleteDirectory($file['name']);
                    $this->messages['deletedFolder'] = true;
                } catch (\League\Flysystem\FilesystemException $e) {
                    $this->errors['deleteFolder'] = true;
                }
            }

        }

        /** редактирование файла */
        else if ($action == 'edit') {

            if ($fileManager->filesystem->fileExists($path . $file['name'])) {
                $file['content'] = $fileManager->filesystem->read($path . $file['name']);
                $this->smarty->assign('file', $file);
            } else {
                $this->errors['fileNotFound'] = true;
            }

        }

        /** сохрание редактируемого файла */
        else if ($action == 'save') {

            if ($fileManager->filesystem->fileExists($path . $file['name'])) {
                $fileManager->filesystem->write($path . $file['name'], $file['content']);
                $this->messages['saved'] = true;
            } else {
                $this->errors['save'] = true;
            }

        }

        /** получение всех директорий и файла по указанному пути */
        $list = $fileManager->ListDirectory($path,  false );

        if (!empty($list['dirs'])) {
            usort($list['dirs'], array($fileManager, 'sortListByName'));
        }

        if (!empty($list['files'])) {
            usort($list['files'], array($fileManager, 'sortListByName'));
        }



        if (!empty($list)) {
            $this->smarty->assign('list', $list);
        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('filemanager')) {
            return $this->smarty->fetch('file-manager.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}

