<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Languages\Languages;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class LanguagesAdmin
 * @package Mnv\Admin\Controllers
 */
class LanguagesAdmin extends Languages
{

    public function fetch()
    {
        global $LANGUAGES;

        $this->smarty->assign('activeItem','langs');
        $this->smarty->assign('title', lang('languages:title'));

        $this->languageId  = getRequestVar('id','');
        $languageIds       = getRequestVar('languageIds', '', true);

        if ($this->isMultiLang()) {
            return $this->smarty->fetch('language.tpl');
        }

        /** изменение основного языка */
        if ($this->action == 'changeDefaultLanguage') {

            if ($this->changeDefaultLanguage()) {
                redirect($this->adminUrl . '/langs');
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** подтверждение на удаление */
        else if ($this->action == 'confirmDelete') {
            if ($this->confirmDelete()) {
                if (!empty($languages->language['isDefault']) && count($LANGUAGES) > 1) {
                    redirect($this->adminUrl . '/langs');
                } else {
                    $this->smarty->assign('language', $this->language);
                }
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** удаление */
        else if ($this->action == 'remove') {
            if ($this->remove()) {
                $this->messages['deleted'] = true;
            } else {
                $this->errors['language_not_found'] = true;
            }
        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            $result = $this->status();
            $response = array('data' => $result);

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }
        /** сортировка */
        else if ($this->action == 'reorder') {
            $ids = array_values($languageIds);
            sort($languageIds);
            $this->reorder($ids, $languageIds);
        }

        $defaultLanguageOptions = array();
        $this->getAllLanguages();
        if (!empty($this->languages)) {
            foreach ($this->languages as $i => $language) {
                $this->languages[$i]['languageTransName'] = lang('languageList:' . $language['codename']);
                $this->languages[$i]['statusName'] = lang('languages:statuses:' . $language['status']);
                if (!$language['isDefault']) {
                    $defaultLanguageOptions[$language['languageId']] = $this->languages[$i]['languageTransName'];
                }
            }
        }

        $this->smarty->assign('defaultLanguageOptions', $defaultLanguageOptions);
        $this->smarty->assign('languages', $this->languages);

        $this->smarty->assign('languageOptions', LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets', Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions', Charset::$charsetOptions);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('langs')) {
            return $this->smarty->fetch('languages.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}



