<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Orders;

/**
 * Class OrderAdmin
 * @package Mnv\Admin\Controllers
 */
class OrderAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders();

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        $orders->orderId = (int)getRequestVar('id', '');
        $orders->order	 = (object)getRequestVar('order','', true);

        switch ($this->action) {
            case 'edit':
                $orders->edit();
                break;
            case 'read_order':
                $orders->edit();
                $orders->order->status    = lang('orders:statuses:'.$orders->order->status);
//                $orders->order->createdBy = langDate(adjustTime($orders->order->createdBy, false, 'd.m.Y H:i'));

                if (!empty($orders->order))
                    $this->smarty->assign('order', $orders->order);
                return $this->smarty->display('module/order-list.tpl');
              break;
            case 'save':
                if ($orders->update($orders->order)) {
                    $this->messages['saved'] = true;
                }

                redirect($this->adminUrl . "/orders?" . $this->buildQueryString([
                    'page'      => $this->page
                ]));
                break;
        }

        if (!($orders->order instanceof \stdClass)) $orders->order = (object)$orders->order;

        $this->smarty->assign('order', $orders->order);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('orders')) {
            return $this->smarty->fetch('order.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}