<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Variants;
use Mnv\Models\Contents\Product;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\EmptyArticleIdException;
use Mnv\Models\Contents\Exceptions\ContentNotDeletedException;
use Mnv\Models\Contents\Exceptions\NotContentApproveException;

/**
 * Class ProductsAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductsAdmin extends Product
{

    public function fetch()
    {
        global $SECTIONS;

        $dateSelector   = new StatsDateSelector(false, 'productDateSelector');
        $variantProduct = new Variants();
        $variants       = null;

        /** title */
        $this->smarty->assign('title', lang($this->module .':title'));
        /** activeItem */
        $this->smarty->assign('activeItem', $this->module);
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        $this->typeContent   = getRequestVar('typeContent', $this->module);

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $this->articleId     = (int) getRequestVar('id', '');
        $contentIds          = getRequestVar('articleIds', '', true);
        $group_action        = getRequestVar('group_action');

        /** получение разделов по типу контента */
        $sections = Helpers::init()->getSectionContent(0, $this->typeContent);


        /** действия */
        if ($this->action === 'remove') {
            try {
                $this->remove();
                Logger::init()->info("Контент «" . $this->content['title'] . "» удален.", $this->manager)->save();
                response()->make("deleteSuccess('" . $this->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (ContentNotDeletedException $e) { /** ошибка при удаление контента */
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        }
        else if ($this->action === 'approve') {

            try {
                $this->approve();
                echo "approveSuccess('" . $this->articleId . "');";
            } catch (NotContentApproveException $e) { /** ошибка при одобрение контента */
                response()->make("approveError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;

        }

        else if ($this->action === 'status') {

            try {
                $this->status();
                response()->json($this->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        }
        /** Групповые действия  */
        else if ($this->action === 'group') {
            if (!empty($group_action)) {
                if (!empty($contentIds)) {
                    foreach ($contentIds as $contentId) {
                        $this->articleId = $contentId;
                        $this->group($group_action);
                    }
                    $response = array('status' => 200, 'message' => 'Успешно выполнено', 'type' => 'success');
                } else {
                    $response =  array('status' => 500, 'message' => 'Необходимо выбрать контент', 'type' => 'error');
                }
            } else {
                $response =  array('status' => 500, 'message' => 'Необходимо выбрать действие', 'type' => 'error');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        else {

            /** фильтровать контента */
            $this->filter = array_filter([
                'dateStart'     => $dateSelector->dateStart,
                'dateEnd'       => $dateSelector->dateEnd,
            ]);

            /** получение всех статей */
            $this->listContent('publishedOn DESC');
            if (!is_null($this->contents)) {
                foreach ($this->contents as $articleId => $content) {
                    $this->contents[$articleId]['statusName'] = lang('general:statuses:' . $content['status']);
                    $this->contents[$articleId]['publishedOn'] = langDate(adjustTime($content['publishedOn'], false, 'd.m.Y'));
                    if ($variants = $variantProduct->getVariants($articleId)) {
                        foreach ($variants as $variantId => $variant) {
                            $this->contents[$variant['productId']]['variants'][$variantId] = $variant;
                        }
                    }
                    $this->contents[$articleId]['image'] = $this->getFile($content['articleId']);
                    $this->contents[$articleId]['section']     = array();
                    if (isset($SECTIONS[$content['sectionId']])) {
                        $this->contents[$articleId]['section'] = $SECTIONS[$content['sectionId']];
                    }
                }
            }

            /** pagination */
            $pages = getPageNums($this->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $this->total);
            $this->smarty->assign('product_variants', $variants);
            $this->smarty->assign('articles', $this->contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('products')) {
            return $this->smarty->fetch('products.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}