<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\DB;
use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Sections\Sections;
use Mnv\Models\Users\UserGroups;

/**
 * Class SectionsAdmin
 * @package Mnv\Admin\Controllers
 */
class SectionsAdmin extends Sections
{

    private static $_table = 'sections';

    public function fetch()
    {
        global $SECTIONS;

        $this->smarty->assign('title', lang('sections:title'));
        $this->smarty->assign('activeItem', 'sections');

        $this->section   = getRequestVar('section', '', true);
        $this->parentId  = (int) getRequestVar('parentId');
        $this->sectionId = (int) getRequestVar('id');
        $sectionIds      = getRequestVar('sectionIds', '', true);

        $this->param     = getRequestVar('param','');

        /** подтвердить удаление */
        if ($this->action == 'confirmDelete') {
            /** проверить сущестуют ли у этого раздела подразделы и контент */
            if ($this->confirmDelete()) {

                if ($this->section['hasSubsections']) {
                    $subsectionOptions = array('delete' => lang('general:delete'));
                    $subsectionOptions[0] = lang('sections:moveToRoot');
                    $subsectionOptions += Helpers::init()->getSectionOptions($this->sectionId);
                    foreach ($subsectionOptions as $key => $name) {
                        if ($key > 0) {
                            $subsectionOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                        }
                    }
                    $this->smarty->assign('subsectionOptions', $subsectionOptions);
                }

                if ($this->section['hasArticles']) {
                    $articleOptions = array('delete' => lang('general:delete'));
                    $articleOptions += Helpers::init()->getSectionOptions($this->sectionId);
                    foreach ($articleOptions as $key => $name) {
                        if ($key > 0) {
                            $articleOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                        }
                    }
                    unset($articleOptions[0]);
                    $this->smarty->assign('articleOptions', $articleOptions);
                }

                $this->smarty->assign('section', $this->section);

            } else {

                $this->errors['section_not_found'] = true;
            }

        }
        /** уделение после подтверждения */
        else if ($this->action == 'deleteConfirmed') {

            if (!empty($this->sectionId)) {
                if ($this->deleteConfirmed($this->param)) {
                    Logger::init()->info("Раздел «" . $this->section['name'] . "» удален", $this->manager)->save();
                    $this->messages['deleted'] = true;
                }
                if (!saveSerializations()) {
                    $this->errors['serializations'] = true;
                }
                if (!writeHtaccess()) {
                    $this->errors['htaccess'] = true;
                }
            } else {
                $this->errors['section_not_found'] = true;
            }
        }
        /** отобразить или скрыть с главного меню */
        else if ($this->action == 'menu') {

            if ($this->menuSection() && !saveSerializations()) {
                $this->errors['serializations'] = true;
            }

            response()->json($this->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        /** измение статуса */
        else if ($this->action == 'status') {

            if ($result = $this->statusSection()) {
                if (!saveSerializations()) {
                    $this->errors['serializations'] = true;
                }
                if (!writeHtaccess()) {
                    $this->errors['htaccess'] = true;
                }
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
        }
        /** сортировать при перемещение */
        else if ($this->action == 'reorder') {

            $ids = array_values($sectionIds);
            sort($sectionIds);
            $this->reorderSections($ids, $sectionIds);

            if (!saveSerializations()) {
                $this->errors['serializations'] = true;
            }
            if (!writeHtaccess()) {
                $this->errors['htaccess'] = true;
            }

        }

//        $this->getParentId();
        if (!empty($this->parentId) && !DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $this->parentId)->getValue()) {
            $this->parentId = (int)DB::init()->connect()->table(self::$_table)->select('parentId')->where('sectionId', $this->parentId)->getValue();
            redirect($this->adminUrl . "/sections?" . $this->buildQueryString(array_filter([
                    'parentId'  => $this->parentId,
                    'page'      => $this->page
                ])));

            die(lang('sections:noSubsections'));
        }

        /** получать информацию о родительском разделе */
        if ($this->parentId > 0) {
            $parent = $SECTIONS[$this->parentId];
            if ($parent['parentId'] > 0) {
                $parent['parent'] = $SECTIONS[$parent['parentId']];
            }
            $this->smarty->assign('parent', $parent);
        }

        /** получение всех разделов */
        $this->listSections();
        if (!empty($this->sections)) {
            foreach ($this->sections as $i => &$iValue) {
                $iValue['statusName']         = lang('sections:statuses:' . $iValue['status']);
                $iValue['typeName']           = lang('sections:types:' . $iValue['type']);
                $iValue['typeContentName']    = lang('sections:typeContents:' . $iValue['typeContent']);

                if (($this->page > 1 && $i == 0) || (($i - $this->limit >= 0) && ($i == count($this->sections) - 1))) {
                    $iValue['isHidden'] = true;
                }
                if (!empty($SECTIONS[$iValue['sectionId']]['children'])) {
                    $iValue['hasSubsections'] = true;
                }
            }
        }

        /** pagination */
        $pages = getPageNums($this->total, $this->page, $this->limit, 0, 4, 4, 0);

//        print_r($this->sections);
        /** вывод в шаблон результатов */
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('sections', $this->sections);
        $this->smarty->assign('parentId', $this->parentId);
        $this->smarty->assign('page', $this->page);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if (Managers::init()->permissions('sections')) {
            return $this->smarty->fetch('sections.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}