<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Socials\Socials;

/**
 * Class SocialAdmin
 * @package Mnv\Admin\Controllers
 */
class SocialAdmin extends Socials
{
    public function fetch()
    {

        $this->smarty->assign('activeItem','socials');
        $this->smarty->assign('title', lang('settings:social'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        $this->social   = getRequestVar('social','', true);
        $this->socialId = (int) getRequestVar('id','');

        if ($this->action == 'add' || $this->action == 'edit') {

            $this->edit();

        } else if ($this->action == 'save') {

            if (empty($this->social['name'])) {
                $this->errors['errorName'] = true;
            }
            if (empty($this->social['fileName'])) {
                $this->errors['fileNameEmpty'] = true;
            }

            if (!$this->isFileName($this->social['fileName'])) {
                $this->errors['fileNameError'] = true;
            }

            if (empty($this->errors)) {
                if (empty($this->socialId)) {
                    $this->add($this->social);
                } else {
                    $this->update($this->social);
                }
                $this->messages['saved'] = true;
            }

            $this->edit();


            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/socials?" . $this->buildQueryString(['page' => $this->page]));
            }
        }

        $this->smarty->assign('social', $this->social);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('socials')) {
            return $this->smarty->fetch('social.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}



