<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;

/**
 * Class StatsErrorAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsErrorAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector = new StatsDateSelector(false, null);

        $this->smarty->assign('activeItem','errors');
        $this->smarty->assign('title', lang('stats:errorInfo'));

        $requestUri = getRequestVar('requestUri');

        $visits = $stats->getStatsError($dateSelector->dateStart, $dateSelector->dateEnd, $requestUri);
        if (!empty($visits)) {
            foreach($visits as $visitId => $visit)
                $visits[$visitId]->visitDate = langDate(adjustTime($visit->visitDate, false, 'd M, H:i:s'));
        }

        /** page numbering */
        $totalItems = $stats->getTotalStatsError($dateSelector->dateStart, $dateSelector->dateEnd, $requestUri);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 4, 4, 2);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);

        $this->smarty->assign('visits', $visits);
        $this->smarty->assign('page', $this->page);

        if (Managers::init()->permissions('errors')) {
            return $this->smarty->fetch('stats/error.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}
