<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Stats;

/**
 * Class StatsOverviewAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsOverviewAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector = new StatsDateSelector(true, null);

        $this->smarty->assign('activeItem', 'overview');
        $this->smarty->assign('title', lang('stats:overviewTitle'));

        /** Обновить статистику если были посещения */
        $stats->updateStatsCacheDaily();

        /** получение статистики */
        $stats->getStatDays($dateSelector->dateStart, $dateSelector->dateEnd);
        if (!empty($stats->days)) {
            foreach ($stats->days as $i => $row) {
                $stats->days[$i]->date = langDate(date($stats->dateFormat, strtotime($row->cacheDate)));
                $stats->visitors += $row->newVisitors + $row->retVisitors;
                $stats->visits += $row->articleVisits + $row->sectionVisits + $row->searchVisits;
                $stats->rssVisits += $row->rssVisits;
            }
        }


        $this->smarty->assign('days', $stats->days);
        $this->smarty->assign('totals', $stats);

        if (Managers::init()->permissions('overview')) {
            return $this->smarty->fetch('stats/overview.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}

