<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\NotUserApproveException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;
use Mnv\Models\Users\UserTypes;

/**
 * Class SubscribersAdmin
 * @package Mnv\Admin\Controllers
 */
class SubscribersAdmin extends AdminMnv
{

    public function fetch()
    {
        $subscribersUser = UserFactory::subscribersUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','subscribers');
        $this->smarty->assign('title', lang('users:title'));

        /** Получаемые параметры $_GET / $_POST */
        $subscribersUser->userId  = (int) getRequestVar('id','');


        if ($this->action === 'remove') {
            try {
                $subscribersUser->remove(UserTypes::CUSTOMER);
                echo "removeElement(" . $subscribersUser->userId . ", 'user');\r\n";
                echo "deleteMessage();\r\n";
            } catch (CannotBeRemovedDeveloperException $e) {
                echo "notDeleteDeveloper()";
            } catch (CannotBeRemovedAdministratorException $e) {
                echo "notDeleteAdministrator()";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            }catch (UserNotDeletedException $e) {
                echo "notDeleteFound()";
            }
            exit;
        }

        if ($this->action === 'approve') {
            try {
                $subscribersUser->approve();
                echo "document.getElementById('status-$subscribersUser->userId').innerHTML = 'АКТИВЕН';\r\n";
                echo  "document.getElementById('user-approve-$subscribersUser->userId').style.display = 'none';\r\n";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            } catch (NotUserApproveException $e) {
                echo "writeStatus('" . lang('users:errors:13') . "', 'aError');\r\n";
                echo "window.setTimeout(\"writeStatus('')\", 5000);\r\n";
            }
            exit;
        }

        /* получение всех менеджеров с картинками */
        $subscribersUser->getAll($this->query, $this->status, 'userId DESC', UserTypes::CUSTOMER, $this->manager);
        foreach ($subscribersUser->users as $userId => $user) {
            $subscribersUser->users[$userId]['registered'] = adjustTime($user['registered'], false, 'd.m.Y');
        }
        /* получение кол-во менеджеров */
        $subscribersUser->total($this->query, $this->status, UserTypes::CUSTOMER, $this->manager);
        $pages = getPageNums($subscribersUser->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('users', $subscribersUser->users);
        $this->smarty->assign('page', $this->page);


        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('subscribers')) {
            return $this->smarty->fetch('subscribers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}




