<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Files\Exception\UploadException;
use Mnv\Core\Files\FileManager;

use League\Flysystem\FilesystemException;

/**
 * Class UploadsAdmin
 * @package Mnv\Admin\Controllers
 */
class UploadsAdmin extends AdminMnv
{

    public $maxSize;

    // TODO: Сделать сортировку по дате (и по расширению)

    /**
     * @throws FilesystemException
     */
    public function fetch()
    {

        $file       = getRequestFiles();
        $path       = getRequestVar('path', '/',  true);
        $folder     = getRequestVar('folder', '',  true);
        $fileIds    = getRequestVar('fileIds', '',  true);

        $name     = getRequestVar('name','',  true);
        $query    = getRequestVar('query','');
        $type     = getRequestVar('type', '');
        $filters  = getRequestVar('filters', '');

        $realPath = realpath(UPLOAD_ROOT.$path).DIRECTORY_SEPARATOR;
        if (strpos($realPath, UPLOAD_ROOT) === false) {
            $realPath = UPLOAD_ROOT . $path;
        }
        $path = str_replace(UPLOAD_ROOT, '', $realPath);

        $fileManager = new FileManager(UPLOAD_ROOT. $path);
        $this->smarty->assign('path', $path);

        /** добавление новой директории */
        if ($this->action == 'new_folder') {
            if (!preg_match('/[^0-9a-zA-Z\-_\. ]/i', $name)) {
                try {
                    $fileManager->filesystem->createDirectory($name);
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:0'));
                } catch (FilesystemException $e) {
                    $this->response = array('status' => 403, 'error'=> lang('fileManager:errors:1'), 'types' => $e->getMessage());
                }
            } else {
                $this->response = array('status' => 500, 'error' => lang('fileManager:errors:5'));
            }
            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление директории если она пустая */
        else if ($this->action == 'delete_folder') {
            if (empty(array_diff(scandir($realPath . $folder), FileManager::$_hidden_files))) {
                try {
                    $fileManager->filesystem->deleteDirectory($folder);
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:3'), 'folder' => $realPath . $folder);
                } catch (FilesystemException $e) {
                    $this->response = array('status' => 500, 'message' => lang('fileManager:errors:3'), 'types' => $e->getMessage(), 'folder' => $realPath . $folder);
                }
            } else {
                $this->response = array('status' => 500, 'message' => lang('fileManager:directoryNotEmpty'), 'folder' => $realPath . $folder);
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление директории с подтверждением если она не пустая */
        else if ($this->action == 'confirm_remove_folder') {
            try {
                $fileManager->filesystem->deleteDirectory($folder);
                $fileManager->deleteAllFilesThisDirectory($folder);
                $this->response = array('status' => 200, 'message' => lang('fileManager:messages:3'), 'folder' => $realPath . $folder);
            } catch (FilesystemException $e) {
                $this->response = array('status' => 500, 'message' => lang('fileManager:errors:3'), 'types' => $e->getMessage(), 'folder' => $realPath . $folder);
            }
            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление файла / удаление файлов */
        else if ($this->action == 'remove') {
            if (isset($fileIds) && !empty($fileIds)){
                try {
                    $fileManager->deleteFiles($fileIds);
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:9'));
                } catch (FilesystemException $e) {
                    $this->response = array('status' => 500, 'message' => lang('fileManager:errors:12'));
                }
            } else {
                $this->response = array('status' => 500, 'message' => 'Пустой ID файла, ищите ошибку)');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** загрузка файлов */
        else if ($this->action == 'upload') {
            try {
                $fileManager->fileUpload($path, $file, $this->manager->userId);
            } catch (FilesystemException $e) {
                $fileManager->response = array('status' => 500, 'message' => $e->getMessage(), 'error' => $e->getMessage());
                response()->json($fileManager->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
                exit();
            }

            response()->json($fileManager->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** получение всего что есть в папке uploads */
        else if ($this->action == 'read_more') {

            $list = $fileManager->ListDirectories('/');
            $where['folder'] = $fileManager->getFolderName($path);
            $list['files'] = $fileManager->listContents($where, $query, $filters, $type, $this->manager->userId);

            if (isset($list['dirs']) && !empty($list['dirs'])) usort($list['dirs'], array($fileManager, 'sortListByName'));

            if (!empty($list)) $this->smarty->assign('list', $list);

            $this->smarty->display('module/uploads-file-list.tpl');

        }

        /** подгрузка файлов при скроле блока */
        else if ($this->action == 'read_more_files') {

            $where['folder'] = $fileManager->getFolderName($path);
            if ($list['files'] = $fileManager->listContents($where, $query, $filters, $type, $this->manager->userId)) {
                $this->smarty->assign('list', $list);
                $items = $this->smarty->fetch('module/uploads-file-list.tpl');
                $this->response = array('status' => 200, 'items'=> $items, 'folder' => $where['folder']);
            }  else {
                $this->response = array('status' => 403, 'items'=> '', 'folder' => $where['folder']);
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }

        /** получение файла по конкретному запросу */
        else if ($this->action == 'read_file') {

            $listArr = array();
            if (isset($fileIds) && !empty($fileIds)) {
                foreach ($fileIds as $id) {
                    $listArr[] = $fileManager->getFile($realPath, $id);
                }

                response()->json($listArr, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
                exit();
            }

        }
    }

}

	
