<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\NotUserApproveException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\UserTypes;

/**
 * Class UsersAdmin
 * @package Mnv\Admin\Controllers
 */
class UsersAdmin extends AdminMnv
{

    public function fetch()
    {
        $siteUser = UserFactory::siteUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','users');
        $this->smarty->assign('title', lang('users:title'));

        $this->smarty->assign('subscribes', lang('users:subscribes'));

        /** Получаемые параметры $_GET / $_POST */
        $siteUser->userId     = (int) getRequestVar('id','');

        if ($this->action === 'remove') {
            try {
                $siteUser->remove(UserTypes::CUSTOMER);
                Logger::init()->info("Пользователь «ID-" . $siteUser->userId . "» удален.", $this->manager)->save();
                echo "removeElement(" . $siteUser->userId . ", 'user');\r\n";
                echo "deleteMessage();\r\n";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            }catch (UserNotDeletedException $e) {
                echo "notDeleteFound()";
            }
            exit;
        }

        if ($this->action === 'approve') {
            try {
                $siteUser->approve();
                echo "document.getElementById('status-$siteUser->userId').innerHTML = 'АКТИВЕН';\r\n";
                echo  "document.getElementById('user-approve-$siteUser->userId').style.display = 'none';\r\n";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            } catch (NotUserApproveException $e) {
                echo "writeStatus('" . lang('users:errors:13') . "', 'aError');\r\n";
                echo "window.setTimeout(\"writeStatus('')\", 5000);\r\n";
            }
            exit;
        }

        $siteUser->getAll($this->query, $this->status, 'userId DESC', UserTypes::CUSTOMER, $this->manager);
        if (!empty($siteUser->users)) {
            foreach ($siteUser->users as $userId => $user) {
                $siteUser->users[$userId]['statusName'] = lang('users:statuses:' . $user['status']);
                $siteUser->users[$userId]['registered'] = langDate(adjustTime(date('m/d/Y H:i:s', $user['registered']), false, 'd.m.Y'));
            }
        }
        /* получение кол-во менеджеров */
        $siteUser->total($this->query, $this->status, UserTypes::CUSTOMER, $this->manager);
        $pages = getPageNums($siteUser->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('users', $siteUser->users);
        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('users')) {
            return $this->smarty->fetch('users.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}




