<?php


$filename = __DIR__ . preg_replace('#(\?.*)$#', '', $_SERVER['REQUEST_URI']);
if (php_sapi_name() === 'cli-server' && is_file($filename)) {
    return false;
}

$router = new \Mnv\Core\Router\Router();

$router->getRequestMethod();

// Custom 404 Handler
$router->set404(function () {
    header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
    echo '404, route not found!';
});

// custom 404
$router->set404('/test(/.*)?', function () {
    header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
    echo '<h1><mark>404, route not found!</mark></h1>';
});

// Static route: /hello
$router->get('/main', function () {
    echo '<h1>bramus/router</h1><p>Visit <code>/hello/<em>name</em></code> to get your Hello World mojo on!</p>';
});

// Dynamic route: /hello/name
//$router->get('/sections', function () {
//    echo 'sections ';
//});
//$router->get('/section', function () {
//    echo 'sections ';
//});
// Subrouting
$router->mount('/section', function () use ($router) {

    // will result in '/movies'
    $router->get('/', function () {
        echo 'movies overview';
    });

    // will result in '/movies'
    $router->post('/', function () {
        echo 'add movie';
    });

    // will result in '/movies/id'
    $router->get('/(\d+)', function ($id) {
        echo 'movie id ' . htmlentities($id);
    });

    // will result in '/movies/id'
    $router->put('/(\d+)', function ($id) {
        echo 'Update movie id ' . htmlentities($id);
    });
});

$router->mount('/articles', function () use ($router) {

    // will result in '/movies'
    $router->get('/', function () {
        echo 'articles';
    });

});
$router->mount('/article', function () use ($router) {

    // will result in '/article'
    $router->get('/', function () {
        echo 'article qwe';
    });

});


// Thunderbirds are go!
$router->run();