{assign var=wrapper value="" scope=global}
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{login:title} - {productName}</title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="/admin/assets/js/main/jquery.min.js"></script>
	<script src="/admin/assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="/admin/assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/ripple.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="/admin/assets/js/plugins/forms/styling/uniform.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/validation/validate.min.js"></script>

	<script src="/admin/assets/js/app.js"></script>
	<script src="/admin/assets/js/demo_pages/login.js"></script>
	<!-- /theme JS files -->

</head>

<body>
	<div class="page-content login-cover">
		<div class="content-wrapper">
			<div class="content d-flex justify-content-center align-items-center">
				{if isset($isRemembered) && $isRemembered eq 1}
					<!-- Unlock form -->
					<form class="login-form {*form-validate*}" method="post" action="{*{$adminUrl}/auth*}" id="login_unlock" accept-charset={$config.charset}>
						<div class="card mb-0">
							<div class="card-body">
								<div class="text-center">
									<div class="card-img-actions d-inline-block mb-3" style="height: 160px">
										<img class="rounded-circle" src="{if isset($adminManager->manager->image)}{$adminManager->manager->image->medium}{else}/admin/assets/images/demo/users/face11.jpg{/if}" width="160" height="160" alt="">
										<div class="card-img-actions-overlay card-img rounded-circle">
											<a href="" class="btn btn-outline bg-white text-white border-white border-2 btn-icon rounded-round">
												<i class="icon-question7"></i>
											</a>
										</div>
									</div>
								</div>
								{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>
								{else}
									{if isset($errors)}
										{if isset($message_limit)}
											<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit}</div>
										{else}
											{if isset($errors)}
												{foreach from=$errors item=error key=key}
													{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}
												{/foreach}
											{/if}
										{/if}
									{/if}
									{if isset($limit_cnt)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} {$limit_cnt|plural:'попытка':'попыток':'попытки'}</div>
									{/if}
									{if isset($isBanned)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>
									{else}
										<div class="text-center mb-3">
											<h6 class="font-weight-semibold mb-0">{if isset($adminManager) && !empty($adminManager)}{$adminManager->manager->fullName}{/if}</h6>
											<span class="d-block text-muted">Unlock your account</span>
										</div>

										<div class="form-group form-group-feedback form-group-feedback-right {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">
											<input type="password" class="form-control" id="adpass" type="password" name="login[password]" placeholder="{login:password}" autocomplete="on">
											<div class="form-control-feedback">
												<i class="icon-user-lock text-muted"></i>
											</div>
										</div>

										<button type="submit" name="action" value="login_unlock" class="btn btn-primary btn-block"><i class="icon-unlocked mr-2"></i> Unlock</button>
									{/if}
								{/if}
							</div>
						</div>
					</form>
					<!-- /unlock form -->
				{else}

					<form class="login-form {*form-validate*}" method="post" action="{*{$adminUrl}/auth*}" id="login" accept-charset={$config.charset}>
						<div class="card mb-0">
							<div class="card-body">
								<div class="text-center mb-3">
									<i class="icon-reading icon-2x text-slate-300 border-slate-300 border-3 rounded-round p-3 mb-3 mt-1"></i>
									<h5 class="mb-0">Войдите в свой аккаунт</h5>
									<span class="d-block text-muted">Ваши учетные данные</span>
								</div>
	                            {if isset($Unknown) && !empty($Unknown)}
								<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$Unknown}</div>
								{/if}
								{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>
								{else}
									{if isset($errors)}
										{if isset($message_limit)}
											<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit nofilter}</div>
										{else}
											{if isset($errors)}
												{foreach from=$errors item=error key=key}
													{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}
												{/foreach}
											{/if}
										{/if}
									{/if}
									{if isset($limit_cnt)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} попыт{$limit_cnt|plural:'ка':'ок':'ки'}</div>
									{/if}
									{if isset($isBanned)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>
									{else}
										<div class="form-group form-group-feedback form-group-feedback-left {if isset($errors.enter_username)}error{/if}">
											<input type="text" class="form-control" id="adlogin" name="login[loginName]"  value="{if isset($login.loginName)}{$login.loginName}{/if}"  placeholder="{login:username}" autocomplete="off">
											<div class="form-control-feedback">
												<i class="icon-user text-muted"></i>
											</div>
										</div>

										<div class="form-group form-group-feedback form-group-feedback-left {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">
											<input type="password" class="form-control" id="adpass" name="login[password]" value="{if isset($login.password)}{$login.password}{/if}" placeholder="{login:password}" autocomplete="on">
											<div class="form-control-feedback">
												<i class="icon-lock2 text-muted"></i>
											</div>
										</div>

										<div class="form-group d-flex align-items-center">
											<div class="form-check mb-0">
												<label class="form-check-label">
													<input type="checkbox" name="login[remember]" class="form-input-styled remember_check" checked data-fouc> Запомнить меня
												</label>
											</div>

										</div>

										<div class="form-group">
											<button type="submit" name="action" value="login" class="btn btn-primary btn-block">{login:signIn}<i class="icon-circle-right2 ml-2"></i></button>
										</div>

									{/if}
								{/if}

{*								<span class="form-text text-center text-muted">*}
{*	*}{*								Продолжая, вы подтверждаете, что ознакомились с нашими <a href="#">Условиями использования</a> и <a href="#">Политикой в отношении файлов cookie</a>.*}
{*									By continuing, you're confirming that you've read our*}
{*									<a href="#">Terms &amp; Conditions</a> and*}
{*									<a href="#">Cookie Policy</a>*}
{*								</span>*}
							</div>
						</div>
					</form>
				{/if}
			</div>
		</div>
	</div>
	<script>
		$('.remember_check').on('change', function(){
			this.value = this.checked ? 1 : 0;
		}).change();
	</script>
</body>
</html>
