<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/bannergroup?action=add"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/bannergroups" class="breadcrumb-item">{$title}</a>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/sections"}
			</div>
		</div>
	</div>
</div>

<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            <div class="card">
	            <div class="">
                    <table class="table table-togglable table-xs table-striped table-hover" id="groups">
                    <thead>
                        <tr>
                            <th data-hide="ID" class="text-center" width="30">#</th>
                            <th data-toggle="true">Название группы</th>
	                        <th data-hide="pages">Отображение</th>
                            <th data-hide="phone" class="text-center">{general:status}</th>
                            <th class="text-center text-muted" width="50"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($groups)}
                    <tbody class="selectable-demo-list groups_list" id="groups_list">

                        {foreach item=group from=$groups name=groups}
                    	<tr id="group-{$group.groupId}" data-id="{$group.groupId}" class="{if $group.status eq 'hidden'}table-warning{/if}">
                            <td class="move_zone text-center text-nowrap"><i class="icon-menu8" style="opacity: 0.5;"></i></td>
                            <td class="text-left" width="100%">{$group.name|escape}</td>
                            <td class="text-nowrap">Разделы: {foreach from=$group.pageNames item=pageName}<span class="badge badge-warning">{$pageName}</span> {/foreach}</td>
                            <td class="text-center" id="status-{$group.groupId}">{$group.statusName}</td>
                            <td class="text-center">
                                <div class="list-icons">
	                                <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/bannergroup?action=edit&id={$group.groupId}"><i class="icon-pencil7"></i></a>
    								<div class="list-icons-item dropdown">
    									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

    									<div class="dropdown-menu dropdown-menu-right">
    										<a class="dropdown-item" href="{$adminUrl}/bannergroup?action=edit&id={$group.groupId}"><i class="icon-pencil7"></i> {general:edit}</a>
                                            <a href="#" class="dropdown-item ajax_action {if $group.status eq 'visible'}active_class{/if}" data-module="bannergroups" data-action="status" data-id="{$group.groupId}" name="status" value="1"><i class="{if $group.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
    										<div class="dropdown-divider"></div>
    										<a href="javascript:;" class="dropdown-item" onclick="remove({$group.groupId}, '{$group.name|escape}', 'bannergroups');"><i class="icon-cross2"></i> {general:delete}</a>
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}
                    </tbody>
                    {if isset($pageNums) && $pageNums > 0}
                    <tfoot><tr><td colspan="6"><div class="">{general:results}</div></td></tr></tfoot>
                    {/if}
                {else}
                    <tbody><tr class="odd"><td class="data none" colspan="6" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
	            </div>
            </div>
    	</div>
    </div>
</div>

	<script>
    $(document).ready(function () {
        {if isset($errors.not_saved)} new Noty({ text: 'Группа баннеров не сохранена', type: 'error' }).show(); {/if}
        {if isset($errors.group_not_found)} new Noty({ text: 'Группа баннеров не найдена', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Группа баннеров сохранена', type: 'success' }).show(); {/if}
    });

    function deleteError(){
        new Noty({ text: 'Ошибка при удаление группы баннеров', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: 'Группа баннеров удалена', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'group');
    }

    $("#groups_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.groups_list',
        placeholder	: "ui-sortable-handle",
        update : function() {
            $.post( "{$adminUrl}/bannergroups?action=reorder", $(this).sortable('serialize'), function( data ) {
                location.reload();
            });
	    }
    }).disableSelection();

</script>



