<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/block?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/blocks" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/blocks"}
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
		    <div class="card">
                {include file="stats/form/selectors.tpl" filter=true url="{$adminUrl}/blocks" filterDate=false}
		    </div>

            <div class="card">
	            <div class="">
                    <table class="table table-togglable table-striped table-hover" id="blocks">
	                    <thead>
	                        <tr>
	                            <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
	                            <th data-toggle="true">{general:table:name}</th>
	                            <th data-hide="phone" class="text-left">{general:table:section}</th>
	                            <th data-hide="phone" class="text-center">{general:table:status}</th>
	                            <th class="text-center text-muted" width="40"><i class="icon-checkmark3"></i></th>
	                        </tr>
	                    </thead>
	                    {if isset($blocks)}
		                    <tbody class="selectable-demo-list articles_list" id="article_list">

		                        {foreach item=block from=$blocks name=blocks}
		                        <tr id="block-{$block.blockId}" data-id="{$block.blockId}" class="{if $block.status eq 'hidden'}table-warning{/if}">
		                            <td nowrap="nowrap">{$block.blockId}</td>
		                            <td><b>{$block.title|truncate:75}</b></td>
		                            <td class="text-left">{if isset($block.section)}{$block.section.name|truncate:25}{/if}</td>
		                            <td class="text-center" id="status-{$block.blockId}">{$block.statusName nofilter}</td>
		                            <td class="text-center">
		                                <div class="list-icons">
			                                <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/block?action=edit&id={$block.blockId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
		                                    <div class="list-icons-item dropdown">
		                                        <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
		                                        <div class="dropdown-menu dropdown-menu-right">
		                                            <a class="dropdown-item" href="{$adminUrl}/block?action=edit&id={$block.blockId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
		                                            <a href="javascript:void('');" id="article-status-{$block.blockId}" class="dropdown-item ajax_action {if $block.status eq 'visible'}active_class{/if}" data-module="blocks" data-action="status" data-id="{$block.blockId}" name="status" value="1" ><i class="{if $block.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
		                                            <div class="dropdown-divider"></div>
		                                            <a href="javascript:void('');" class="dropdown-item" onclick="remove({$block.blockId}, '{$block.title|escape}', 'blocks');"><i class="icon-cross2"></i> {general:delete}</a>
		                                        </div>
		                                    </div>
		                                </div>
		                            </td>
		                        </tr>
		                        {/foreach}

		                    </tbody>
	                    {else}
	                        <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
	                    {/if}
	                </table>
	            </div>

                {include file="module/pagination.tpl" url="{$adminUrl}/blocks" params="{$buildQueryString}"}
            </div>
    	</div>
    
    </div>
</div>

	<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: 'Блок сохранен', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: 'Блок не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: 'Блок не найден', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function deleteSuccess(id){
        new Noty({ text: 'Блок удален', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'block');
    }
    function deleteError(){
        new Noty({ text: 'ошибка при удаление блока', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function notFound(){
        new Noty({ text: 'Блок не найден', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }



</script>



