<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/brands?page={if isset($page)}{$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/brands" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
                                    <input type="text" class="form-control" id="name" autocomplete="off" name="brand[name]" value="{if isset($brand.name)}{$brand.name}{/if}" onblur="proposeFileName('name', 'fileName', 'brand', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="brand[fileName]" value="{if isset($brand.fileName)}{$brand.fileName}{/if}" />
                                </div>
            			    </div>
{*				            <div class="col-md-12">*}
{*					            <div class="form-group form-group-float">*}
{*						            <label class="form-group-float-label is-visible">Страна</label>*}
{*                                    {html_options options=$countryList name="brand[countryId]" id="status" selected=$brand.countryId|default:'' class="form-control select"}*}
{*					            </div>*}
{*				            </div>*}
                        </div> 
                    </div>
    		    </div>

	            <div class="card collapse {if isset($brand.enableGallery) and $brand.enableGallery eq 1}show{/if}" id="gallery-card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">{general:card:imageLibrary}</h6>
			            <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
		            </div>
		            <div class="card-body">
			            <div class="row gallery gallery-product gallery-sortable mt-2" id="fileList">
                            {if isset($brand.gallery)}
                                {foreach item=file from=$brand.gallery}
						            <figure class="gallery-item mb-0" id="gallery-item-{$file->imageId}" data-id="{$file->imageId}">
							            <div class="move_zone image">
								            <img src="{$file->medium}" alt="{if isset($file->title)}{$file->title}{/if}"/>
								            <ul class="gallery-item-controls">
									            <li><span>{$file->orderBy}</span></li>
									            <li>
                                                    <span class="edit_image" id="edit_image_{$file->imageId}"
                                                          data-title="{$file->title}"
                                                          data-alias="{$file->alias}"
                                                          data-description="{$file->description}"
                                                          data-link="{$file->link}"
                                                          data-position="{$file->position}"
                                                          onclick="editPictureInfo({$file->imageId}, 'Добавить описание к картинке', 'brand');"><i class="icon-quill4"></i></span>
									            </li>
									            <li>
										            <span onclick="deletePicture({$file->imageId}, 'brand');"><i class="icon-cross2"></i></span>
									            </li>
								            </ul>
							            </div>
							            <div class="meta" id="meta_image_{$file->imageId}" style="padding: 0;">
								            <span id="im_title" class="font-weight-semibold">{$file->title}</span>
								            <span id="im_alias" class="font-weight-semibold">{$file->alias}</span>
								            <span id="im_description">{$file->description nofilter}</span>
								            <span id="im_link">{$file->link}</span>
								            <span id="im_position" class="badge badge-primary" style="color: #fff;">{$file->position}</span>
							            </div>
						            </figure>
                                {/foreach}
                            {/if}
			            </div>
		            </div>
		            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
			            <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
			               data-type="gallery"
			               data-path="/"
			               data-action="read_more"
			            ><i class="icon-images2 mr-2"></i> {general:uploadFiles} </a>
			            <a class="btn btn-sm btn-primary btn-sorting collapse" href="javascript:void('')"
			               data-action="sortPictures"
			               data-module="brand"
			            ><i class="icon-checkmark3 mr-2"></i> {general:apply}</a>
		            </div>
	            </div>

	            <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:description}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>
                    <div class="card-body flex-column flex-md-row m-0 p-0">
	                    <textarea name="brand[content]" class="description">{if isset($brand.content)}{$brand.content}{/if}</textarea>
    			    </div>
    		    </div>
    
                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>	&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/brands?page={if isset($page)}{$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{general:cancel}</a>
                </div>
            
            </div>
    
    
            <div class="col-md-4">
        		<div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
    				<div class="card-body border-top-0">
    					<figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses name="brand[status]" id="status" selected=$brand.status|default:'visible' class="form-control select"}
                            </div>
                        </figure>
					    <figure>
						    <div class="form-check">
							    <label class="form-check-label">
								    <input type="checkbox" class="form-check-input-styled" name="brand[enableGallery]" data-fouc="" value="1"
                                           {if isset($brand.enableGallery) and $brand.enableGallery eq 1}checked{/if}
								           data-toggle="collapse"
								           data-target="#gallery-card"
								           aria-expanded="{if isset($brand.enableGallery) and $brand.enableGallery eq 1}true{else}false{/if}"
								    >
								    Фотогалерея к этой публикации
							    </label>
						    </div>
					    </figure>
                        <figure>
                            {if isset($brand.addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$brand.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand.addedBy.loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                            {if isset($brand.modifiedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:modified}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$brand.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand.modifiedBy.loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                        </figure>
                        
    				</div>
    			</div>
    			
                <div class="card">
    				<div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:addImage}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
                    <div class="card-body">
                        <div class="content-image gallery">
                            {if isset($brand.image)}
                                <div class="gallery-item item-{$brand.brandId}" id="image_general">
                                    <div class="image" id="image-{$brand.brandId}">
                                        <img src="{$brand.image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$brand.image->imageId}, 'brand');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>

                                </div>
                            {/if}
                        </div>

                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>

    			</div>
    
    			<div class="card">
    			    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:seo}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>
    
        			<div class="card-body flex-column flex-md-row m-0">
        				<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:metaTitle}</label>
                            <input class="form-control" autocomplete="off" id="meta_title" type="text" name="brand[meta_title]" value="{if isset($brand.meta_title)}{$brand.meta_title}{/if}"/>
                        </div>
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:keywords}</label>
	                        <div class="input-group">
		                        <input type="text" class="form-control tokenfield-primary" id="keywords" name="brand[keywords]" value="{if isset($brand.keywords)}{$brand.keywords}{/if}" data-fouc>
	                        </div>
                        </div>
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:description}</label>
                            <textarea id="description" name="brand[description]" class="form-control" rows="3">{if isset($brand.description)}{$brand.description}{/if}</textarea>
                        </div>
        			</div>
        		</div>
    
            </div>
    
        </div>

    </div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
  	
    $(document).ready(function () {
      
      {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 3000 }).show(); {/if}
      {if isset($errors.title)} new Noty({ text: '{brands:errors:1}', type: 'error', timeout: 3000 }).show(); {/if}
      {if isset($errors.not_saved)} new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.image_not_saved)} new Noty({ text: '{brands:errors:5}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.fileName)} new Noty({ text: '{brands:errors:7}', type: 'error', timeout: 3000 }).show();;{/if}
      {if isset($errors.fileNameExists)} new Noty({ text: '{brands:errors:8}', type: 'error', timeout: 1500 }).show(); {/if}

      {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show();{/if}

      
    });

    $(function () {
        function e() { meta_title_touched || $("#meta_title").val(m()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function m() { return name = $("#name").val() }
        function i() { return name = $("#name").val() }
        function t() { return name = $("#name").val() }
        function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        meta_title_touched = !0, 
        keywords_touched = !0, 
        description_touched = !0, 
        fileName_touched = !0, 
        ($("#meta_title").val() == i() || "" == $("#meta_title").val()) && (meta_title_touched = !1), 
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1), 
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1), 
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1), 
        $("#meta_title").change(function () { meta_title_touched = !0 }),
        $("#keywords").change(function () { keywords_touched = !0 }),
        $("#description").change(function () { description_touched = !0 }),
        $("#fileName").change(function () { fileName_touched = !0 }),
        $("#name").keyup(function () { e() })
    });


    $(document).ready(function(){
        // добавление информации к картинке в галереи


        // сортировка галереи
        $("#fileList").sortable({
            items: "> figure.gallery-item",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            cursor: "move",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            forcePlaceholderSize: true,
            connectWith: '.gallery-product',
            placeholder: "gallery-sortable",
            stop : function () {
                $('.btn-sorting').addClass('show');
            }
        }).disableSelection();

        // применить сортировку галереи
        $(document).on("click", ".btn-sorting" , function() {
            var module = $(this).attr('data-module'), action = $(this).attr('data-action'), ids = [];
            $('#fileList figure.gallery-item').each(function() {
                ids.push($(this).attr("data-id"));
            });
            $.post("{$adminUrl}/"+module, { imageIds: ids, action: action }, function (response) {
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
                $('.btn-sorting').removeClass('show');
            });
        });

    });

    </script>
