<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="javascript:;" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary mx-1" data-popup="popover-solid" data-trigger="hover" title=" Добавить группу" data-placement="top" href="{$adminUrl}/managergroups?action=edit{if !empty($page)}&page={$page}{/if}"><i class="icon-plus3"></i></a>
				<a class="btn btn-sm btn-primary mx-1" data-popup="popover-solid" data-trigger="hover" title="{general:add} администратора" data-placement="top" href="{$adminUrl}/developer?action=add{if !empty($page)}&page={$page}{/if}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> {header:statistics}</a>
				<a href="{$adminUrl}/developers" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="javascript:;" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/developers"}
			</div>
		</div>
	</div>
</div>

<div class="content">
    			

    <div class="card">
	    <div class="">
	        <table class="table table-togglable table-xs table-striped table-hover managers-archive" id="managers">
            <thead>
                <tr>
                    <th data-hide="ID" width="30%">{managers:title}</th>
                    <th data-hide="image">{managers:email}</th>
                    <th data-toggle="true">{general:table:type}</th>
                    <th data-toggle="true">{general:table:status}</th>
                    <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                </tr>
            </thead>
            {if isset($managers)}
            <tbody>
                {foreach item=manager from=$managers name=managers}
                <tr id="manager-{$manager.userId}" class="{if $manager.status eq 'hidden'}table-warning{/if}">
                    <td nowrap="nowrap">
                        <div class="d-flex align-items-center">
							<div class="mr-3"><img src="{if isset($manager.image)}{$manager.image->medium}{else}/admin/assets/img/no_images.jpg{/if}" alt="{if !empty($manager.fullName)}{$manager.fullName}{/if}" class="rounded-circle" width="32" height="32"></div>
							<div>
								<a href="{$adminUrl}/developer?action=edit&id={$manager.userId}" class="text-default font-weight-semibold">{if !empty($manager.fullName)}{$manager.fullName nofilter}{/if}</a>
								<div class="text-muted font-size-sm">
									<span class="badge badge-mark {if $manager.status eq 1}border-success{elseif $manager.status eq 1}border-slate{elseif $manager.status eq 2 || $manager.status eq 3}border-danger{elseif $manager.status eq 4 || $manager.status eq 5}border-primary{else}border-grey-400{/if} mr-1"></span>
									{$manager.last_login|date_format:"%d.%m.%Y %H:%M"}
								</div>
							</div>
						</div>
                    </td>

                    <td nowrap="nowrap">{if !empty($manager.email)}{$manager.email}{else}Email не указан{/if}</td>
                    <td nowrap="nowrap">{$manager.accessLevelName|upper}</td>
                    <td nowrap="nowrap">{$manager.statusName}</td>
                    <td class="text-left">
                        <div class="list-icons">
	                        <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/developer?action=edit&id={$manager.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
							<div class="list-icons-item dropdown">
                                {if $smarty.foreach.managers.iteration > 2}
	                            <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
	                            <div class="dropdown-menu dropdown-menu-right">
									<a class="dropdown-item" href="{$adminUrl}/developer?action=edit&id={$manager.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
									<div class="dropdown-divider"></div>
									<a href="javascript:void('');" class="dropdown-item" onclick="remove({$manager.userId}, '{if !empty($manager.fullName)}{$manager.fullName}{/if}', 'developers')"><i class="icon-cross2"></i> {general:delete}</a>
								</div>
                                {/if}
							</div>
						</div>
                    </td>
                </tr>
            {/foreach}
            </tbody>

            {else}
            <tbody><tr class="odd"><td class="data none" colspan="5" align="center">- {general:none} -</td></tr></tbody>
            {/if}
        </table>
	    </div>
        {include file="module/pagination.tpl" url="{$adminUrl}/developers" params="{$buildQueryString}"}
    </div>
</div>

<script>

    function deleteSuccess(id) {
        new Noty({ text: '{managers:messages:1}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'manager');
    }

    function deleteError() {
        new Noty({ text: '{managers:errors:15}', layout: 'topRight', type: 'error' }).show();
    }

    function userNotFound() {
        new Noty({ text: '{managers:errors:1}', layout: 'topRight', type: 'error' }).show();
    }

    function notDeleteAdministrator() {
        new Noty({ text: '{managers:errors:6}', layout: 'topRight', type: 'error' }).show();
    }

    function notDeleteDeveloper() {
        new Noty({ text: '{managers:errors:14}', layout: 'topRight', type: 'error' }).show();
    }



</script>



