<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/faqs">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/faqs" class="breadcrumb-item">{$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">
        <div class="row"> 
            <div class="col-md-12">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
            			    <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.question)}text-danger{/if}">{sliders:general:title}</label>
                                    <input type="text" class="form-control" name="faq[question]" value="{if isset($faq.question)}{$faq.question}{/if}" />
                                </div>
            			    </div>
				            <div class="col-md-6">
					            <div class="form-group form-group-float">
						            <label class="form-group-float-label is-visible">{general:status}</label>
	                                {html_options options=$statuses name="faq[status]" selected=$faq.status|default:'' class="form-control select"}
					            </div>
				            </div>

                        </div> 
                    </div>
    		    </div>
	            <div class="card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">{general:card:description}</h6>
			            <div class="header-elements">
				            <div class="list-icons">
					            <a class="list-icons-item" data-action="collapse"></a>
				            </div>
			            </div>
		            </div>
		            <div class="card-body flex-column flex-md-row m-0 p-0">
			            <textarea id="description" name="faq[answer]" class="description">{if isset($faq.answer)}{$faq.answer}{/if}</textarea>
		            </div>
	            </div>

                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/faqs">{general:cancel}</a>
                </div>
            
            </div>
        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>
    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Вопрос сохранен', type: 'success' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Вопрос не сохранен', type: 'error', timeout: 1500 }).show(); {/if}

        {if isset($errors.question)} new Noty({ text: '{sliders:errors:1}', type: 'error' }).show(); {/if}

    });
</script>
