<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/logo " class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>
		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item" href="javascript:;" data-toggle="collapse" data-target="#add_logo"><i class="icon-file-plus"></i>
					<span class="action_logo">{if !empty($logos->logoUrl)}{logo:change}{else}{logo:add}{/if}</span>
				</a>
			</div>
		</div>
	</div>
</div>


<div class="content">

	<div id="add_logo" class="collapse card">
		<div class="card-header bg-transparent header-elements-inline">
			<h6 class="card-title">{logo:add}</h6>
			<div class="header-elements">
				<div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div>
			</div>
		</div>
		<div id="upload_files" class="dropzone dropzone-product">
			<div class="dz-default dz-message"></div>
		</div>
	</div>

	<div class="card">
		<div class="">
			<table class="table table-togglable table-striped table-hover" id="logos">
				<thead>
				<tr>
					<th data-hide="ID" class="text-center" width="30">{logo:title}</th>
					<th data-hide="image" class="text-center" nowrap="nowrap">{logo:logoFile}</th>
					<th data-hide="image">{logo:logoUrl}</th>
					<th data-hide="image" class="text-center" nowrap="nowrap">{logo:logoExt}</th>
					<th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
				</tr>
				</thead>
                {if !empty($logos->logoUrl)}
					<tbody>
					<tr id="logo-1">
						<td><img id="preview" src="{$UPLOAD_URL}/{$logos->logoUrl}" alt="" style="max-width: 200px;max-height: 100px;"></td>
						<td class="text-center">{$logos->logoName}</td>
						<td nowrap="nowrap">{$UPLOAD_URL}/{$logos->logoUrl}</td>
						<td class="text-center">{$logos->logoType}</td>
						<td class="text-center">
							<div class="list-icons">
								<div class="list-icons-item dropdown">
									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

									<div class="dropdown-menu dropdown-menu-right">
										<a href="javascript:;"  onclick="deleteLogo('{$logos->logoUrl|escape}', '{$logos->logoName|escape}', 'logo');" class="dropdown-item" ><i class="icon-cross2"></i> {general:delete}</a>
									</div>
								</div>
							</div>
						</td>

					</tr>
					</tbody>
                {else}
					<tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                {/if}
			</table>
		</div>
	</div>

</div>


<script>

    function deleteSuccess(id) {
        new Noty({ text: '{logo:messages:1}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'logo');
    }

    function deleteError() {
        new Noty({ text: 'Логотип не найден', layout: 'topRight', type: 'error' }).show();
    }

    var logoLang = "{foreach item=language from=$LANGUAGES}{if ($SITE_LANG eq $language.codename) || (!$SITE_LANG && $language.isDefault)}{$language.codename}{/if}{/foreach}";
    Dropzone.autoDiscover = false;

    $("#upload_files").dropzone({
        paramName: "file",
        url: "{$adminUrl}/logo?action=upload",
        addRemoveLinks: true,
        dictRemoveFile: 'Скрыть',
        maxFilesize: 2,
        maxFiles: 1,
        acceptedFiles: "image/*",
        init: function() {
            this.on("success", function(file, response) {
                console.log(response);
                new Noty({ text: response.message, type: 'success' }).show();
                setTimeout(function() {
                    location.reload()
                },2500);

            });

            this.on('error', function (file, response){
                file.previewElement.classList.add("dz-error");
                new Noty({ text: response.message, type: 'error' }).show();
            });

        }
    });

</script>




