<style>
    #variants_block.single_variant thead th.variant_name, #variants_block.single_variant tbody td.variant_name, #variants_block.single_variant tbody td.variant_move #variants_block.single_variant #add_variant {
        display: none;
    }
</style>
<form method="post" enctype="multipart/form-data">
    
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;	&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/products?page={if isset($page)}{$page}{/if}{$buildQueryString}">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/products" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center">
    			</div>
    		</div>
    	</div>
    </div>
    <!-- /page header -->
    
    
    <!-- Content area -->
    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:tabs:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			
        			    <div class="row">
            			   
            			    <div class="col-md-6">
				                <div class="form-group form-group-float">
					                <label class="form-group-float-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
                                    {html_options options=$sections name="product[sectionId]" id="sectionId" selected=$product.sectionId|default:0 class="form-control select select-search"}
				                </div>
				                <div class="form-group form-group-float">
					                <label class="form-group-float-label is-visible">{general:alias}</label>
					                <input class="form-control" autocomplete="off" id="alias" type="text" name="product[alias]" value="{if isset($product.alias)}{$product.alias}{/if}" />
				                </div>

            			    </div>

                            <div class="col-md-6">
	                            <div class="form-group form-group-float">
		                            <label class="form-group-float-label is-visible {if isset($errors.title)}text-danger{/if}">{products:general:title}</label>
		                            <input type="text" class="form-control" id="title" autocomplete="off" name="product[title]" value="{if isset($product.title)}{$product.title}{/if}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
	                            </div>

	                            <div class="form-group form-group-float">
		                            <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
		                            <input  type="text" class="form-control" id="fileName" autocomplete="off" name="product[fileName]" value="{if isset($product.fileName)}{$product.fileName}{/if}" />
	                            </div>
            			    </div>
                        </div> 
                    </div>
    		    </div>

	            {* Варианты продукта *}
	            <div class="card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">Варианты продукта</h6>
			            <div class="header-elements">
				            <div class="list-icons">
					          <a class="list-icons-item" data-action="collapse"></a>
				            </div>
			            </div>

		            </div>
		            <div class="card-body">
			            <div class="table-responsive">

                            {if !empty($product_variants)}
                                {assign var=first_variant value=$product_variants|@first}
                                {if $product_variants|@count >= 1 && !empty($first_variant.name)}
                                    {assign var=variantShowName value=show}
                                {else}
                                    {assign var=variantShowName value=''}
                                {/if}
                            {else}
                                {assign var=variantShowName value=''}
                            {/if}
				            <table class="table table_variants" id="variants_block" >
					            <thead id="header">
						            <tr>
							            <th>#</th>
							            <th class="variant_name collapse  {$variantShowName}">Название варианта</th>
							            <th>{products:articul}</th>
							            <th>{products:price}</th>
							            <th>{products:oldPrice}</th>
							            <th>{products:stock}</th>
						            </tr>
					            </thead>

								<tbody id="variants" class="variants">

                                {foreach $product_variants as $variant}
					            <tr>
						            <td class="move_list"><i class="icon-menu8 text-muted"></i></td>
						            <td class="variant_name collapse  {$variantShowName}">
							            <input class="form-control" type="hidden" name="variants[{$variant.id}][id]" value="{$variant.id}" />
							            <div class="input-group">
								            <input class="form-control" type="text" name="variants[{$variant.id}][name]" value="{$variant.name|default:""}" autocomplete="off"/>
								            <span class="input-group-append"><button type="button" class="del_variant btn btn-light"><i class="icon-cross3"></i></button></span>
							            </div>
						            </td>
						            <td><input class="form-control" type="text" name="variants[{$variant.id}][sku]" value="{$variant->sku|default:""}" autocomplete="off"/></td>
						            <td><input class="form-control" type="text" name="variants[{$variant.id}][price]" value="{$variant->price|default:"0.00"}" autocomplete="off"/></td>
						            <td><input class="form-control" type="text" name="variants[{$variant.id}][oldPrice]" value="{$variant->oldPrice|default:"0.00"}" autocomplete="off"/></td>
						            <td>
							            <div class="input-group">
								            <input class="form-control" type="text" name="variants[{$variant.id}][stock]" value="{$variant.stock|default:"∞"}" autocomplete="off" placeholder="∞"/>
								            <span class="input-group-text">шт.</span>
							            </div>
						            </td>
					            </tr>
	                            {foreachelse}
	                                <tr>
		                                <td class="move_list"><i class="icon-menu8  text-muted"></i></td>
		                                <td class="variant_name collapse">
			                                <input class="form-control" type="hidden" name="variants[0][id]" value="" />
			                                <div class="input-group">
				                                <input class="form-control" type="text" name="variants[0][name]" value="" autocomplete="off"/>
				                                <span class="input-group-append"><button type="button" class="del_variant btn btn-light"><i class="icon-cross3"></i></button></span>
			                                </div>
		                                </td>
		                                <td><input class="form-control" type="text" name="variants[0][sku]" value="" autocomplete="off"/></td>
		                                <td><input class="form-control" type="text" name="variants[0][price]" value="0.00" autocomplete="off"/></td>
		                                <td><input class="form-control" type="text" name="variants[0][oldPrice]" value="0.00" autocomplete="off"/></td>
		                                <td>
			                                <div class="input-group">
				                                <input class="form-control" type="text" name="variants[0][stock]" value="" autocomplete="off" placeholder="∞"/>
				                                <span class="input-group-text">шт.</span>
			                                </div>
		                                </td>
	                                </tr>
                                {/foreach}
					         </tbody>

				            </table>
			            </div>
		            </div>
		            <div class="card-footer text-right">
			            <button type="button" class="btn btn-outline-primary add_variant">Добавить вариант</button>
		            </div>
	            </div>

                {* Gallery *}
                <div class="card collapse {if isset($product.enableGallery) and $product.enableGallery eq 1}show{/if}" id="gallery-card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:imageLibrary}</h6>
                        <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
                    </div>
                    <div class="card-body">
                        <div class="row gallery gallery-product gallery-sortable mt-2" id="fileList">
                            {if isset($product.gallery)}
                                {foreach item=file from=$product.gallery}
                                   <figure class="gallery-item mb-0" id="gallery-item-{$file->imageId}" data-id="{$file->imageId}">
                                       <div class="move_zone image">
                                           <img src="{$file->medium}" alt="{if isset($file->title)}{$file->title}{/if}"/>
                                           <ul class="gallery-item-controls">
                                               <li><span>{$file->orderBy}</span></li>
                                               <li>
                                                   <span class="edit_image" id="edit_image_{$file->imageId}"
                                                         data-title="{$file->title}"
                                                         data-alias="{$file->alias}"
                                                         data-description="{$file->description}"
                                                         data-link="{$file->link}"
                                                         data-position="{$file->position}"
                                                         onclick="editPictureInfo({$file->imageId}, 'Добавить описание к картинке', 'product');"><i class="icon-quill4"></i></span>
                                               </li>
                                               <li>
                                                   <span onclick="deletePicture({$file->imageId}, 'product');"><i class="icon-cross2"></i></span>
                                               </li>
                                           </ul>
                                       </div>
                                       <div class="meta" id="meta_image_{$file->imageId}" style="padding: 0;">
                                           <span id="im_title" class="font-weight-semibold">{$file->title}</span>
                                           <span id="im_alias" class="font-weight-semibold">{$file->alias}</span>
                                           <span id="im_description">{$file->description nofilter}</span>
                                           <span id="im_link">{$file->link}</span>
                                           <span id="im_position" class="badge badge-primary" style="color: #fff;">{$file->position}</span>
                                       </div>
                                   </figure>
                                {/foreach}
                            {/if}
                        </div>
                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="gallery"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-images2 mr-2"></i> {general:uploadFiles} </a>
                        <a class="btn btn-sm btn-primary btn-sorting collapse" href="javascript:void('')"
                           data-action="sortPictures"
                           data-module="product"
                        ><i class="icon-checkmark3 mr-2"></i> {general:apply}</a>
                    </div>
                </div>

				{* summary / content *}
                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:description}</h6>
                        <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
    			    </div>
                    <div class="card-body flex-column flex-md-row m-0  p-0">
        			    <ul class="nav nav-tabs nav-tabs-top mb-0" style="border-bottom: 0px solid #ddd;">
        				    <li class="nav-item"><a href="#summary" class="nav-link active show" data-toggle="tab">{general:tabs:summary}</a></li>
                            <li class="nav-item"><a href="#content" class="nav-link" data-toggle="tab">{general:tabs:content}</a></li>
        			    </ul>
        
                        <div class="tab-content border-top-0 rounded-top-0 mb-0">
        				    <div class="tab-pane fade show active" id="summary">
        					    <textarea name="product[summary]" class="description">{if isset($product.summary)}{$product.summary}{/if}</textarea>
        				    </div>
        
                            <div class="tab-pane fade" id="content">
        					    <textarea name="product[content]" class="description">{if isset($product.content)}{$product.content}{/if}</textarea>
        				    </div>
        				</div>
    			    </div>
    		    </div>
                {* Свойства продукта *}
{*	            {$features|var_dump}*}
	            <div id="features_card" class="card {if empty($features)}collapse{/if}">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">Свойства продукта</h6>
			            <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
		            </div>
		            <div class="card-body">

			            <ul class="features-list media-list mb-3">
				            {if !empty($features)}
	                            {foreach $features as $feature}
						            <li class="media feature" data-feature={$feature.id}>
							            <div class="col-md-4 mr-3"><label class="mb-0">{$feature.name}</label></div>
							            <div class="col-md-4"><input class="form-control" type="text" name="options[{$feature.id}]" value="{if isset($options[$feature.id]) && !empty($options)}{$options[$feature.id].value}{/if}" autocomplete="off" placeholder=""/></div>
							            <div class="col-md-4"><input class="form-control" type="text" name="icons[{$feature.id}]" value="{if isset($options[$feature.id]) && !empty($options)}{$options[$feature.id].icon}{else}{$feature.fileName}{/if}" autocomplete="off" placeholder=""/></div>
						            </li>
	                            {/foreach}
				            {/if}
			            </ul>

			            {* Новые свойства *}
			            <ul class="new_features media-list mb-3">
				            <li id="new_feature" class="media">
					            <div class="col-md-4 mr-3">
						            <label class="property">
							            <input class="form-control" type=text name="new_features_names[]">
						            </label>
					            </div>
					            <div class="col-md-4"><input class="form-control" type="text" name="new_features_values[]" /></div>
					            <div class="col-md-4"><input class="form-control" type="text" name="new_features_icons[]" /></div>
				            </li>
			            </ul>
		            </div>
		            <div class="card-footer text-right">
			            <button id="add_new_feature" type="button" class="btn btn-outline-primary add">Добавить новое свойство</button>
		            </div>
	            </div>

                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>	&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/products?page={if isset($page)}{$page}{/if}{$buildQueryString}">{general:cancel}</a>
                </div>
            
            </div>
    
    
            <div class="col-md-4">
        		<div class="card">
    							
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
    				<div class="card-body border-top-0">
                        <figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses name="product[status]" id="status" selected=$product.status|default:'' class="form-control select"}
                            </div>
                        </figure>
                        <figure>
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input-styled" name="product[enableGallery]" data-fouc="" value="1"
                                           {if isset($product.enableGallery) and $product.enableGallery eq 1}checked{/if}
                                           data-toggle="collapse"
                                           data-target="#gallery-card"
                                           aria-expanded="{if isset($product.enableGallery) and $product.enableGallery eq 1}true{else}false{/if}"
                                    >
                                    Фотогалерея к этой публикации
                                </label>
                            </div>
                        </figure>
                        <figure>
                            <div class="form-group">
                                <label class="form-group-float-label is-visible">{general:misc:publishDate}</label>
	                            <div class="row">
		                            <div class="col-md-12">
			                            <div class="input-group">
											<span class="input-group-prepend">
												<span class="input-group-text"><i class="icon-calendar3"></i></span>
											</span>
				                            <input type="text" class="form-control daterange-single" name="product[publishedOn]" value="{$product.publishedOn|default:$adjustedNow}" readonly>
			                            </div>
		                            </div>
	                            </div>
                            </div>
                        </figure>
                        <figure>

{*                            <div class="form-group form-group-float">*}
{*                                <label class="form-group-float-label is-visible">Особенность</label>*}
{*                                <select name="product[special]" class="form-control select">*}
{*                                    <option value="">Выбрать особенность товара</option>*}
{*                                    <option value="new"      {if isset($product.special) and $product.special eq 'new'}      selected{/if}>Новинка</option>*}
{*                                    <option value="sale"     {if isset($product.special) and $product.special eq 'sale'}     selected{/if}>Акция</option>*}
{*                                    <option value="hit"      {if isset($product.special) and $product.special eq 'hit'}      selected{/if}>Хит продаж</option>*}
{*                                    <option value="featured" {if isset($product.special) and $product.special eq 'featured'} selected{/if}>Рекомендуемый</option>*}
{*                                    <option value="sold"     {if isset($product.special) and $product.special eq 'sold'}     selected{/if}>Распроданный</option>*}

{*                                </select>*}
{*                            </div>*}
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:misc:featured}</label>
                                <select name="product[isFeatured]" class="form-control select">
                                    <option value="0" {if isset($product.isFeatured) and $product.isFeatured eq 0} selected{/if}>{general:no}</option>
                                    <option value="1" {if isset($product.isFeatured) and $product.isFeatured eq 1} selected{/if}>{general:yes}</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-group-float-label is-visible">{general:misc:comments}</label>
                                <select name="product[commentsEnabled]" class="form-control select">
                                    <option value="0" {if isset($product.commentsEnabled) and $product.commentsEnabled == 0} selected{/if}>{general:defaultComments}</option>
                                    <option value="-1" {if isset($product.commentsEnabled) and $product.commentsEnabled == -1} selected{/if}>{general:disableComments}</option>
                                    <option value="1" {if isset($product.commentsEnabled) and $product.commentsEnabled == 1} selected{/if}>{general:enableComments}</option>
                                </select>
                            </div>
                        </figure>
                        <figure>
                            {if isset($product.addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$product.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.addedBy.loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                            {if isset($product.modifiedOn)}
                            <div class="d-sm-flex flex-sm-wrap">
                                <div class="font-weight-semibold">{general:modified}</div>
                                <div class="ml-sm-auto mt-2 mt-sm-0">{$product.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.modifiedBy.loginName|default:"{general:unknowUser}"})</div>
                            </div>
                            {/if}
                        </figure>
                        
    				</div>
    			</div>

{*
				{if isset($brands)}
                <div class="card">
    				<div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title {if isset($errors.brand)}text-danger{/if}">{general:card:brand}</h6>
    					<div class="header-elements">
    						<div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div>
                		</div>
    				</div>


    				<div class="card-body">
    					<div class="form-group form-group-float">
                            <select name="product[brand]" class="form-control select  select-search">
                                <option value="">Выбрать бренд</option>
                                {foreach item=brandList from=$brands name=brands key=$key}
                                <optgroup label="{$key|upper}">
                                {foreach from=$brandList item=brand}
                                    <option value="{$brand->fileName}" {if isset($product.brand) and $product.brand eq $brand->fileName}selected{/if}>{$brand->name}</option>
                                    {/foreach}
                                </optgroup>
                                {/foreach}
                            </select>
                        </div>
    				</div>
    			</div>
    			{/if}
*}

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:addImage}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="content-image gallery">
                            {if isset($product.image)}
                                <div class="gallery-item item-{$product.image->imageId}" id="image_general">
                                    <div class="image" id="image-{$product.image->imageId}">
                                        <img src="{$product.image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$product.image->imageId}, 'product');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>
                                </div>
                            {/if}
                        </div>

                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>

                </div>

{*                <div class="card">*}
{*    				<div class="card-header bg-transparent header-elements-inline">*}
{*        				<h6 class="card-title">{general:card:rating}</h6>*}
{*    					<div class="header-elements">*}
{*    						<div class="list-icons">*}
{*    	                		<a class="list-icons-item" data-action="collapse"></a>*}
{*                    		</div>*}
{*                		</div>*}
{*    				</div>*}


{*    				<div class="card-body">*}
{*    					<div><p class="mb-3 text-muted">Значение рейтинга: <code class="font-weight-semibold" id="noui-stepping-val"></code> </p></div>*}
{*                        <div class="noui-height-helper" id="noui-slider-stepping" data-fouc></div>*}
{*                        <span class="font-weight-semibold" id="noui-stepping-val"></span>*}
{*                        <input type="text" class="form-control ion-height-helper" id="noui-rating" name="product[rating]" value="{if !empty($product.rating)}{$product.rating}{/if}" data-fouc style="height: 0;">*}

{*                        <div class="form-group form-group-float">*}
{*                            <label class="form-group-float-label is-visible">Количество голосов:</label>*}
{*                            <input class="form-control" autocomplete="off" id="votes" type="text" name="product[votes]" value="{if isset($product.votes)}{$product.votes}{/if}"/>*}
{*                        </div>*}
{*    				</div>*}
{*    			</div>*}
{*                *}
    
    			<div class="card card-collapsed">
    			    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:seo}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
							    <ul class="list-inline mb-0">
								    <li class="list-inline-item"><button type="button" class="btn btn-outline-primary border-transparent" onclick="auto_keywords();">Сгенерировать ключевые слова</button></li>
								    <li class="list-inline-item"><a class="list-icons-item" data-action="collapse"></a></li>
							    </ul>
                    		</div>
                		</div>
    			    </div>
    
        			<div class="card-body flex-column flex-md-row m-0">
        				<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:metaTitle}</label>
                            <input class="form-control" autocomplete="off" id="meta_title" type="text" name="product[meta_title]" value="{if isset($product.meta_title)}{$product.meta_title}{/if}"/>
                        </div>
				        <div class="form-group">
					        <label class="form-group-float-label is-visible">{general:keywords}</label>
					        <div class="input-group">
						        <input type="text" class="form-control tokenfield-primary" id="keywords" name="product[keywords]" value="{if isset($product.keywords)}{$product.keywords}{/if}" data-fouc>
					        </div>
				        </div>
{*                        <div class="form-group">*}
{*                            <label class="form-group-float-label is-visible">{general:keywords}</label>*}
{*                            <textarea id="keywords" name="product[keywords]" class="form-control" rows="3">{if isset($product.keywords)}{$product.keywords}{/if}</textarea>*}
{*                        </div>*}
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:description}</label>
                            <textarea id="description" name="product[description]" class="form-control" rows="3">{if isset($product.description)}{$product.description}{/if}</textarea>
                        </div>
        			</div>
        		</div>
    
            </div>
    
        </div>

    </div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    	
    $(document).ready(function () {
      
        {if isset($errors.access_denied)}       new Noty({ text: '{products:errors:0}',  type: 'error', timeout: 1500 }).show();     {/if}
        {if isset($errors.title)}               new Noty({ text: '{products:errors:1}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.brand)}               new Noty({ text: 'Необходимо указать бренд продукта',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.sectionId)}           new Noty({ text: '{products:errors:2}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.not_saved)}           new Noty({ text: '{products:errors:3}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.no_sections)}         new Noty({ text: '{products:errors:4}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.image_not_saved)}     new Noty({ text: '{products:errors:5}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.article_not_found)}   new Noty({ text: '{products:errors:6}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileName)}            new Noty({ text: '{products:errors:7}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameExists)}      new Noty({ text: '{products:errors:8}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameProhibited)}  new Noty({ text: '{products:errors:11}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.fileNameCharacters)}  new Noty({ text: '{products:errors:12}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.htaccess)}            new Noty({ text: '{products:errors:9}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.serializations)}      new Noty({ text: '{products:errors:10}', type: 'error', timeout: 1500 }).show();    {/if}


        {if isset($messages.saved)}             new Noty({ text: '{products:messages:0}', type: 'success', timeout: 1500 }).show();  {/if}
    });

    function successSortImageMessage(){
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }

    // meta date
    $(function () {
        function e() { meta_title_touched || $("#meta_title").val(m()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function m() { return name = $("#title").val() }
        function i() { return name = $("#title").val() }
        function t() { return name = $("#title").val() }
        function n() { return fileName = $("#title").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        meta_title_touched = !0, 
        keywords_touched = !0, 
        description_touched = !0, 
        fileName_touched = !0, 
        ($("#meta_title").val() == i() || "" == $("#meta_title").val()) && (meta_title_touched = !1), 
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1), 
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1), 
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1), 
        $("#meta_title").change(function () { meta_title_touched = !0 }),
        $("#keywords").change(function () { keywords_touched = !0 }),
        $("#description").change(function () { description_touched = !0 }),
        $("#fileName").change(function () { fileName_touched = !0 }),
        $("#title").keyup(function () { e() })
    });

    // rating
    var articleId = '{if isset($article.articleId)}{$article.articleId}{/if}';
    var ratingValue = '{if isset($product.rating)}{$product.rating}{/if}';

    // var slider_stepping = document.getElementById('noui-slider-stepping');
    // noUiSlider.create(slider_stepping, {
    //     start: [ratingValue],
    //     step: 1,
    //     range: {
    //         'min': [1],
    //         'max': [5]
    //     },
    //     direction: $('html').attr('dir') == 'rtl' ? 'rtl' : 'ltr'
    // });
	//
    // var slider_stepping_val = document.getElementById('noui-stepping-val');
    // slider_stepping.noUiSlider.on('update', function( values, handle ) {
    //     slider_stepping_val.innerHTML = values[handle];
    //     console.log(values[handle]);
    //     document.getElementById('noui-rating').value  = values[handle];
	//
    // });

    // сортировка галереи
    $("#fileList").sortable({
        items: "> figure.gallery-item",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        cursor: "move",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        forcePlaceholderSize: true,
        connectWith: '.gallery-product',
        placeholder: "gallery-sortable",
        stop : function () {
            $('.btn-sorting').addClass('show');
        }
    }).disableSelection();
    
    // применить сортировку галереи
    $(document).on("click", ".btn-sorting" , function() {
        var module = $(this).attr('data-module'), action = $(this).attr('data-action');
        var ids = [];
        $('#fileList figure.gallery-item').each(function() {
            ids.push($(this).attr("data-id"));
        });

        $.ajax({
            url: "{$adminUrl}/"+module,
            method: "POST",
            data: { imageIds: ids, action: action },
            success: function (d) {
                //console.log(d)
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
                $('.btn-sorting').removeClass('show');
            }
        });
    });

    $("#variants").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_list",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        axis: 'y',
        cancel: '#header',
        cursor: "move",
        connectWith: '.variants',
        placeholder: "ui-sortable-handle",
        update	   : function(event, ui) {
            var sections = new Array();

            $('#section_list tr').each(function() {
                sections.push($(this).attr("data-id"));
            });

            console.log(sections);
            // $.ajax({
            //     url:"{$adminUrl}/sections",
            //     method:"POST",
            //     data:{ sectionIds: sections, action: 'reorder', session_id: sessionId },
            //     success:function(data) {
            //         location.reload();
            //         //alert(data);
            //     }
            // });
        }
    }).disableSelection();

    // Добавление варианта
    // Добавление варианта
    $(document).on('click', '.add_variant', function() {
        // если есть то клонируем tr
        if ($('.variant_name').is('.show')) {
            const parent = $('.table_variants tbody:first');
            const clone = parent.children(':last').clone();
            const index = parseInt(clone.find('input:first').attr('name').match(/\[([0-9]+)\]/)[1]) + 1;

            // Очистить значения клонирования и обновить индекс
            clone.find('input, select').val('').each(function() {
                $(this).attr('name', $(this).attr('name').replace(/\[[0-9]+\]/, '[' + index + ']'));
            }).end().appendTo(parent);
        }
        // если нету то добавляем поле с классом variant_name
        else {
            $('.table_variants th.variant_name, .table_variants td.variant_name').addClass('show');
        }

        return false;
    });

    // Удаление варианта
    $(document).on('click', '.del_variant', function() {
        if ($("#variants tr").length > 1) {
            $(this).closest("tr").fadeOut(200, function() {
                $(this).remove();
            });
        } else {
            $('.table_variants th.variant_name, .table_variants td.variant_name').removeClass('show');
            $('.table_variants .variant_name input[name*=variant][name*=name]').val('');
        }

        return false;
    });


    var OptionsList = function() {

        var showSectionFeatures = function(sectionId) {

            $('#features_card').removeClass('collapse');
            $('ul.features-list').empty();

            $.post('{$adminUrl}/product', { action: 'features', sectionId: sectionId, id: $('input[name="product[articleId]"]').val() }, function(response) {
                $.each(response, function(index, feature) {
                    console.log(feature)
	                var line = $('<li class="media feature" >' +
		                '<div class="col-md-4 mr-3"><label class="mb-0 property"></label></div>' +
		                '<div class="col-md-4"><input class="form-control" type="text" /></div>' +
		                '<div class="col-md-4"><input class="form-control" type="text" /></div>' +
		                '</li>');

                    var optionList = line.clone(true);
                    optionList.find("label.property").text(feature.name);
                    optionList.find("input").attr('name', "options["+feature.id+"]").val(feature.value);
                    optionList.appendTo('ul.features-list').find("input")
                        .autocomplete({
                            serviceUrl:'{$adminUrl}/product&action=featureId',
                            minChars:0,
                            params: { featureId: feature.id },
                            noCache: false
                        });
                });
            });
            return false;
        };


        var _componentOptions = function() {

            $('select#sectionId:first').change(function() {
                showSectionFeatures($("option:selected",this).val());
            });


            // Автодополнение свойств
            $('ul.features-list input[name*=options]').each(function(index) {
                feature_id = $(this).closest('li').attr('data-feature');
                $(this).autocomplete({
                    serviceUrl:'{$adminUrl}/product',
                    minChars:0,
                    params: { action: 'featureId', feature_id:feature_id },
                    noCache: false
                });
            });

            // Добавление нового свойства товара
            var new_feature = $('#new_feature').clone(true);
            $('#new_feature').remove().removeAttr('id');
            $('#add_new_feature').click(function() {
                $(new_feature).clone(true).appendTo('ul.new_features').fadeIn('slow').find("input[name*=new_feature_name]").focus();
                return false;
            });

        };


        return {
            init: function() {

                _componentOptions();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        OptionsList.init();
    })

    </script>
