<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
                {if !empty($sections)}
					<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/project?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
                {/if}
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/projects" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/projects"}
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            {if empty($sections)}
			    <div class="card">
				    <div class="alert bg-danger text-white alert-dismissible m-0">
					    <span class="font-weight-semibold">Перед добавлением, добавьте хотя бы один <a href="{$adminUrl}/section?action=add&parentId=0" class="text-white">раздел</a>.</span>
				    </div>
			    </div>
            {/if}

		    <div class="card">
                {include file="stats/form/selectors.tpl" filter=true url=$generate_url filterDate=true}
		    </div>

		    <div class="card">
			    <div class="">
				    <table class="table table-togglable table-striped table-hover" id="articles">
					    <thead>
					    <tr>
						    <th data-hide="phone" class="text-center" width="30">
							    <input type="checkbox" class="form-check-input-styled-primary content_check_all" data-fouc>
						    </th>
						    <th data-hide="phone" class="text-center" width="80">{general:table:date}</th>
						    <th data-hide="image" class="text-center" width="120">{general:table:image}</th>
						    <th data-toggle="true">{general:table:name}</th>
						    <th data-hide="phone" class="text-center">{general:table:section}</th>
						    <th data-hide="phone" class="text-center">{general:table:status}</th>
						    <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
					    </tr>
					    </thead>
                        {if isset($articles)}
						    <tbody class="selectable-demo-list articles_list" id="article_list">
                            {foreach item=article from=$articles name=articles}
							    <tr id="article-{$article.articleId}" data-id="{$article.articleId}" class="{if $article.status eq 'hidden'}table-warning{/if}">
								    <td class="text-center"><span class="list-icons-item"><input type="checkbox" class="form-check-input-styled-primary content_list_check" data-fouc value="{$article.articleId}" data-id="{$article.articleId}" ></span></td>
								    <td class="text-left text-nowrap"><span data-popup="popover-solid" data-trigger="hover" title="ID - {$article.articleId}" data-placement="top">{$article.publishedOn|date_format:$config.date_format_custom}</span></td>
								    <td class="text-center"><img src="{if isset($article.image)}{$article.image->small}{else}/admin/assets/img/no_images.jpg{/if}" class="img-preview" alt="{$article.title}"/></td>
								    <td><b data-popup="popover-solid" data-trigger="hover" title="{$article.title}" data-placement="top">{$article.title|truncate:75}</b></td>
								    <td class="text-center">{$article.section.name|truncate:25}</td>
								    <td class="text-center" id="status-{$article.articleId}">{$article.statusName nofilter}</td>
								    <td class="text-center">
									    <div class="list-icons">
										    <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$generate_url|substr:0:-1}?action=edit&id={$article.articleId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
										    <div class="list-icons-item dropdown">
											    <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
											    <div class="dropdown-menu dropdown-menu-right">
                                                    {if $article.status eq 'pending'}
													    <a class="dropdown-item" id="article-approve-{$article.articleId}" href="javascript:void('');" style="color: #ec407a;" onclick="return approve({$article.articleId}, '{$mod}');"><i class="icon-thumbs-up2"></i> {general:approve}</a>
                                                    {/if}
												    <a href="{$article.url}" target="_blank" class="dropdown-item"><i class="icon-rotate-ccw2"></i> {general:view}</a>
												    <a href="javascript:void('');" class="dropdown-item"><i {if $article.isFeatured}style="color:yellow;"{/if} class="icon-star-full2"></i> {general:table:favorites}</a>
												    <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$article.articleId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
												    <a href="javascript:void('');" id="article-status-{$article.articleId}" class="dropdown-item ajax_action {if $article.status eq 'visible'}active_class{/if}" data-module="{$mod}" data-action="status" data-id="{$article.articleId}" name="status" value="1" ><i class="{if $article.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
												    <div class="dropdown-divider"></div>
												    <a href="javascript:void('');" class="dropdown-item" onclick="remove({$article.articleId}, '{$article.title|escape}', '{$mod}');"><i class="icon-cross2"></i> {general:delete}</a>
											    </div>
										    </div>
									    </div>
								    </td>
							    </tr>
                            {/foreach}
						    </tbody>
                        {else}
						    <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                        {/if}
				    </table>
			    </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/projects" params="{$buildQueryString}"}
		    </div>

    	</div>
	    <div class="card footer_navbar collapse bg-light m-0">
		    <form method="post" action="#">
			    <div class="card-footer bg-white d-flex justify-content-center align-items-center py-2">
				    <ul class="nav nav-pills mb-0">
					    <li class="nav-item px-2 wmin-sm-200">
						    <div class="form-group mb-0">
							    <select class="form-control select content_select_action" name="group_action" data-fouc>
								    <option value="">Выбрать действие</option>
                                    {*								    <option value="copy">Создать дубликат</option>*}
                                    {*								    <option value="section">Переместить в раздел</option>*}
								    <option value="status"> Изменить статус</option>
								    <option value="remove">Удалить выбранное</option>
							    </select>
						    </div>
					    </li>
					    <li class="nav-item px-2">
						    <button class="btn btn-sm btn-primary px-3 content_save_button" type="button">Применить</button>
					    </li>
                        {*					    <li class="nav-item px-2">*}
                        {*						    <input type="text" class="form-control" id="articleIds" name="articleIds" value="" />*}
                        {*					    </li>*}
				    </ul>
			    </div>
		    </form>
	    </div>
    </div>
</div>

    {if isset($messages.saved)}<span id="saved" onclick="new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show();"></span>{/if}
    
    {if isset($errors.access_denied)}<span id="accessDeniedError" onclick="new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show();"></span>{/if}
	{if isset($errors.not_saved)}<span id="notSavedError" onclick="new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show();"></span>{/if}
	{if isset($errors.no_sections)}<span id="noSectionsError" onclick="new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show();"></span>{/if}
	{if isset($errors.article_not_found)}<span id="articleNotFoundError" onclick="new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show();"></span>{/if}
	<script>
    $(document).ready(function () {
      
        {if isset($messages.saved)} $('#saved').click();{/if}
        
        {if isset($errors.access_denied)} $('#accessDeniedError').click();{/if}
        {if isset($errors.not_saved)}   $('#notSavedError').click();{/if}
        {if isset($errors.no_sections)} $('#noSectionsError').click(); {/if}
        {if isset($errors.article_not_found)} $('#articleNotFoundError').click();{/if}
        
    });
    
    function deleteMessage(){ new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show(); }
    function successImageMessage(){ new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show(); }


    // выбрать все
    $(document).on("change", ".content_check_all", function () {
        if ($(this).is(":checked")) {
            $('.content_list_check').each(function () {
                if (!$(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')
        } else {
            $('.content_list_check').each(function () {
                if ($(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
        }
    });

    // быбрать один
    $(document).on("change", ".content_list_check", function () {
        if ( $('input.content_list_check:checked').length > 0 ) {
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')

        } else {
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
            if ($('.content_check_all').is(":checked")) $('.content_check_all').trigger("click");
            // $('.content_check_all').trigger("click");
        }
    });

    $(document).on('click', '.content_save_button',  function () {
        var articleIds = [];
        $('.content_list_check').each(function () {
            if ($(this).is(":checked")) {
                articleIds.push($(this).attr("data-id"));
            }
        });

        var group_action_text =  $(".content_select_action :selected").text();
        var group_action =  $(".content_select_action").val();

        bootbox.confirm({
            // message: 'Вы действительно хотите "'+group_action_text+'"? <br> action: => ' + group_action + ' <br>ids: => ' + articleIds ,
            message: 'Вы действительно хотите "'+group_action_text+'"?' ,
            callback: function(result) {
                console.log(result);
                if (result === true) {
                    $.post('index.php?mod=projects&action=group', { articleIds: articleIds, group_action: group_action }, function (data) {
                        console.log(data);
                        new Noty({ text: data.message, type: data.type }).show();
                        if (data.status === 200) {
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);

                        }
                    }, 'json');
                }
            }
        });
    });

</script>



