<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center"></div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/error" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center"></div>
		</div>
	</div>
</div>

<div class="content">
	<div class="row">
		<div class="col-md-12">

			<div class="card">
				{include file="stats/form/selectors.tpl" action='' select=''}
			</div>

			<div class="card">
				<div class="card-header bg-white header-elements-sm-inline">
					<h5 class="card-title">{stats:errorInfo}</h5>
				</div>
				<div class="">
					<table class="table table-xs table-striped table-actions table-hover">
						<tbody>
							<tr>
								<td class="text-left text-nowrap" width="200">{stats:requestUri}:</td>
								<td class="text-left">
									{if isset($requestUri)}
{*									<a href="{$requestUri|urldecode|escape}" target="_blank">{$requestUri|urldecode|escape}</a>*}
									<a href="{$requestUri|escape}" target="_blank">{$requestUri|escape}</a>
									{/if}
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="card">
				<div class="">
					<table class="table table-xs table-striped table-actions table-hover">
						<thead>
							<tr>
								<th style="min-width:120px;">{stats:referer}</th>
								<th style="min-width:100px;">{general:date}</th>
								<th class="text-center text-nowrap">{stats:visitorId}</th>
							</tr>
						</thead>

						{if isset($visits) && !empty($visits)}
						<tbody>
							{foreach item=visit from=$visits name=visits}
								<tr id="visit-{$visit->visitId}">
									<td class="" width="100%">{if $visit->referer}<a href="{$visit->referer}" target="_blank">{$visit->referer|truncate:80}</a>{else}{stats:unknown}{/if}</td>
									<td class="text-nowrap">{$visit->visitDate}</td>
									<td class="text-center text-nowrap"><a href="{$adminUrl}/visitor?visitorId={$visit->visitorId}">{$visit->visitorId}</a></td>

								</tr>
							{/foreach}
						</tbody>
						{else}
							<tbody><tr class="odd"><td class="text-center" colspan="3">- {general:none} -</td></tr></tbody>
						{/if}
					</table>
				</div>
				{include file="module/pagination.tpl" url="{$adminUrl}/error" params="&requestUri={$requestUri}"}
			</div>

		</div>
	</div>
</div>