<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center"></div>
		</div>
	</div>


	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/overview" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/errors"}
			</div>
		</div>
	</div>
</div>

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
				{include file="stats/form/selectors.tpl" action="{$adminUrl}/errors" select="errors"}
			</div>
			<div class="card">
				<div class="card-header bg-white header-elements-sm-inline">
					<h5 class="card-title">{$title}</h5>
					<div class="header-elements">
						<ul class="list-inline list-inline-dotted mb-0">
							<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">404</span> - <span class="text-danger font-size-sm">{stats:errorCodes:404}</span></li>
							<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">503</span> - <span class="text-danger font-size-sm">{stats:errorCodes:503}</span></a></li>
							<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">301</span> - <span class="text-danger font-size-sm">{stats:errorCodes:301}</span></a></li>
						</ul>
					</div>
				</div>
				<div class="">
					<table class="table table-xs table-striped table-actions table-hover">
						<thead>
						<tr>
							<th class="text-center" width="100">{stats:code}</th>
							<th class="text-left">{stats:requestUri}</th>
						</tr>
						</thead>
						{if isset($errors) && !empty($errors)}
							<tbody>
							{foreach item=error from=$errors}
								<tr>
									<td class="code{$error->errorCode}" align="center">{$error->errorCode}</td>
									<td class="" width="100%"><a href="{$adminUrl}/error?requestUri={$error->requestUri nofilter}">{$error->requestUri|truncate:80|escape}</a></td></tr>
							{/foreach}
							</tbody>
						{else}
							<tbody> <tr class="odd"><td class="" colspan="2" align="center">- {general:none} -</td></tr></tbody>
						{/if}

					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/errors" params="{if isset($filterErrorCode)}&filterErrorCode={$filterErrorCode}{/if}"}
			</div>


		</div>
	</div>
</div>
<!-- /content area -->