<?php

namespace Mnv\Core\Bot;

use Mnv\Core\Utilities\Curl\Curl;
use Mnv\Core\Bot\Exceptions\InvalidTokenException;
use Mnv\Core\Bot\Exceptions\InvalidChatIdException;

final class Telegram
{

    /**
     * @throws InvalidChatIdException
     * @throws InvalidTokenException
     */
    private function __construct(int $permissionSend = 0, string $token = null, string $chatID = null, $txt)
    {
        $this->sending($permissionSend,  $token, $chatID, $txt);

    }

    /**
     * @throws InvalidChatIdException
     * @throws InvalidTokenException
     */
    public static function send(int $permissionSend = 0, string $token = null, string $chatID = null, $txt): self
    {
        return new self($permissionSend,  $token, $chatID, $txt);
    }

    /**
     * @throws InvalidChatIdException
     * @throws InvalidTokenException
     */
    private function sending(int $permissionSend = 0, string $token = null, string $chatID = null, $text): void
    {
        if ($permissionSend == 1) {
            if (empty($token))
                throw new InvalidTokenException();

            if (empty($chatID))
                throw new InvalidChatIdException();

            $curl = new Curl();
            $curl->post('https://api.telegram.org/bot' . $token . '/sendMessage', [
                'chat_id'       => $chatID,
                'parse_mode'    => 'html',
                'text'          => $text,
            ]);

            if ($curl->error) {
                $curl->response = 'Error: ' . $curl->errorCode . ': ' . $curl->errorMessage;
            }
        }
    }


}