<?php

namespace Mnv\Core;

use Mnv\Core\Database\Database;
use Mnv\Core\Singleton\SingletonTrait;

/**
 * Class DB
 * @package Mnv\Core
 */
final class DB
{
    use SingletonTrait;

    /** @var Database|null  */
    private ?Database $_handle;

    /** DB constructor. */
    private function __construct()
    {
        $databaseConfig = include GLOBAL_ROOT .'/includes/config.inc.php';
        $this->_handle = new Database($databaseConfig);
    }

    /**  @return Database  */
    public function connect(): Database
    {
        return $this->_handle;
    }

}