<?php

namespace Mnv\Core\Database;

interface DatabaseInterface
{
    /**
     * @param null $type
     * @param null $argument
     *
     * @return mixed
     */
    public function getValue($type = null, $argument = null);

    /**
     * @param null $type
     * @param null $argument
     * @return mixed
     */
    public function getAllIndexes($type = null, $argument = null);

//    /**
//     * @param null $indexKey
//     * @return mixed
//     */
//    public function indexKey($indexKey = null);
//
//    /**
//     * @param null $valueKey
//     * @return mixed
//     */
//    public function valueKey($valueKey = null);

    /**
     * @param null $type
     * @param null $argument
     *
     * @return mixed
     */
    public function get($type = null, $argument = null);

    /**
     * @param null $type
     * @param null $argument
     *
     * @return mixed
     */
    public function getAll($type = null, $argument = null);

    /**
     * @param array $data
     * @param bool  $type
     *
     * @return mixed
     */
    public function update(array $data, $type = false);

    /**
     * @param array $data
     * @param bool  $type
     *
     * @return mixed
     */
    public function insert(array $data, $type = false);

    /**
     * @param array $data
     * @param false $type
     *
     * @return mixed
     */
    public function replace(array $data, $type = false);

    /**
     * @param bool $type
     *
     * @return mixed
     */
    public function delete($type = false);
}
