<?php

//declare(strict_types=1);

namespace Mnv\Core;

use Mnv\Core\Singleton\SingletonTrait;
use Mnv\Models\Users\UserGroups;
use Mnv\Models\Users\UserTypes;
use Mnv\Core\Managers\AdminManager;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class Managers
 * @package Mnv\Core
 */
final class Managers
{

    use SingletonTrait;

    /** @var  */
    private $_manager;

    /**
     * Получение менеджера
     * @method adminManager
     */
    public function adminManager(?int $managerId)
    {
        $fields = 'userId, fullName, firstName, middleName, lastName, loginName, accessLevel, fileId, userType, groupName AS accessLevelName';
        if ($this->_manager = DB::init()->connect()->table('users')->join('user_group', 'usergroup_id', '=', 'accessLevel')->select($fields)->where('userId', $managerId)->in('userType', [UserTypes::DEVELOPER, UserTypes::ADMIN])->get()) {
            $this->getImage();

            if (!is_null($this->_manager->accessLevel)) {
                $this->_manager->permissions = DB::init()->connect()->table('user_group_privileges')->select('privilege')->where('usergroup_id', $this->_manager->accessLevel)->indexKey('privilege')->valueKey('privilege')->getAllIndexes();
            }
        }

//        print_r($this->manager);
        return $this->_manager;
    }

    public function get()
    {
        return $this->_manager;
    }

    /** Получение фото менеджера */
    private function getImage(): void
    {
        if (!empty($this->_manager->userId) && (!empty($this->_manager->fileId) && $this->_manager->fileId > 0) && $file = DB::init()->connect()->table('files')->select('fileId, folder, path, fileName, size')->where('fileId', $this->_manager->fileId)->get()) {
            $this->_manager->image = ImageSizes::init()->get(null, $file);
        }
    }

    /**
     * Блокировка пользователя или злоумышленника на 10 часов
     */
    public function setUserBanned(): void
    {
        if (Config::getValue('check_banned_ips') && (Config::getValue('check_banned_ips') === 1)) {
            $ban['visitorIp']   = UserInfo::get_ip();
            $ban['bannedOn']    = date('Y-m-d H:i:s');
            $ban['expiresOn']   = date('Y-m-d H:i:s', strtotime('+10 hours'));

            DB::init()->connect()->table('users_banned_ips')->insert($ban);

            $this->unsetBanned();
        }
    }

    public function getUserBanned(): bool
    {
        if (!DB::init()->connect()->table('users_banned_ips')->where('visitorIp', UserInfo::get_ip())->get()) {
            return true;
        }

        return false;
    }

    /**
     * @return int
     */
    public function unsetBanned(): int
    {
        return $_SESSION['admin'][AdminManager::SESSION_FIELD_BANNED] = 0;
    }

    public function permissions(?string $module): bool
    {
        return in_array($module, $this->_manager->permissions, true) && in_array($this->_manager->accessLevel, UserGroups::arrayGroup(), true);
    }

    /**
     * получение информации о пользователях, создавших и изменивших контент
     * getting info about users who created and modified the content
     */
    public static function gettingInfoAboutUsers(&$object): void
    {
        if (isset($object['addedBy'], $object['modifiedBy'])) {
            $managers = DB::init()->connect()->table('users')->select('userId, loginName')->in('userId', [$object['addedBy'], $object['modifiedBy']])->indexKey('userId')->getAllIndexes('array');
            $object['addedBy']    = !empty($managers[$object['addedBy']]) ? $managers[$object['addedBy']] : unknownUser();
            $object['modifiedBy'] = !empty($managers[$object['modifiedBy']]) ? $managers[$object['modifiedBy']] : unknownUser();
            $object['addedOn']    = adjustTime($object['addedOn'], false, 'd.m.Y H:i');
            $object['modifiedOn'] = adjustTime($object['modifiedOn'], false, 'd.m.Y H:i');
            if (isset($object['publishedOn'])) {
                $object['publishedOn'] = adjustTime($object['publishedOn']);
            }
        }
    }

}