<?php

namespace Mnv\Core;

use JsonException;
use Mnv\Models\Users\UserTypes;

/**
 * Class Menu
 * @package Mnv\Core
 */
class Menu
{

    private $menu;

    public function __construct()
    {
        try {
            $this->menu = json_decode(file_read(GLOBAL_ROOT . "/admin/menu/menu.json"), true, 512, JSON_THROW_ON_ERROR);
        } catch (JsonException $e) {
            print $e->getMessage();
        }
    }

    /**
     * Права доступа / Access rights
     *
     * @param $manager
     * @return array
     */
    public function accessRights($manager): array
    {
        $result = array();
        foreach ($this->menu as $key => $item) {
            $result[$key] = $item;
            $child = array();
            if (($manager->userType === UserTypes::DEVELOPER) && in_array('managers', $item['activeItems'], true)) {
                $developer[] = [
                    'name' => 'Разработчики',
                    'icon' => 'icon-users',
                    'fileName' => 'developers'
                ];
                $result[$key]['children'] = array_merge($developer, $item['children']);
                $result[$key]['activeItems'] = array_merge($item['activeItems'], ['developers']);
            }

            foreach ($result[$key]['children'] as $childrenKey => $children) {
                $child[$childrenKey] = $children;
            }

            unset($result[$key]['children']);

            $result[$key]['children'] = $child;

        }

        return $result;
    }

    /**
     * Формирование меню и получение меню админ панели
     * stats,overview,visitors,visitor,referer,bots,orders,users,sections,sliders,catalog,brands,contents,articles,products,features,news,logo,settings,socials,maps,languages,
     * currencies,robots,error,errors,lowerrors,syserrors,serverinfo,inivars,managers,templates,filemanagers,files,translations,comments,about,payments
     */
    public function getMenu($manager, Design $smarty): void
    {
        // проверяем на пустоту прав, так как у пользователя сайта нет разрешение на доступ к админ панели
        if (!empty($manager->permissions)) {
            foreach ($this->menu as $key => $item) {

                $this->menu[$key]['children'] = $this->generateChildrenMenu($item['children'], $manager);
                if (($manager->userType === UserTypes::DEVELOPER) && in_array('managers', $item['activeItems'], true)) {
                    $developer[] = [
                        'name' => 'Разработчики',
                        'icon' => 'icon-android',
                        'fileName' => 'developers'
                    ];
                    $this->menu[$key]['children'] = array_merge($developer, $item['children']);
                    $this->menu[$key]['activeItems'] = array_merge($item['activeItems'], ['developers']);
                }
                if (empty($this->menu[$key]['children'])) {
                    unset($this->menu[$key]);
                }
            }
        }  else {
            foreach ($this->menu as $key => $item) {
                $this->menu[$key]['children'] = $this->generateChildrenMenu($item['children'], $manager);
            }
        }

        $smarty->assign('menu', $this->menu);
    }

    /**
     * Получение подразделов
     *
     * @param $children
     * @param $manager
     * @return mixed
     */
    private function generateChildrenMenu($children, $manager)
    {
        if (!empty($manager->permissions)) {
            foreach ($children as $k => $child) {
                if ($this->access($child['fileName'], $manager)) {
                    continue;
                }

                unset($children[$k]);
            }
        } else {
            foreach ($children as $k => $child) {
                $children[$k] = $child;
            }
        }
        return $children;
    }

    /**
     * проверяем разрешение на доступ к контроллеру
     *
     * @param $permission
     * @param $manager
     * @return bool
     */
    private function access($permission, $manager): bool
    {
        if (empty($permission)) {
            return false;
        }

        if (is_array($manager->permissions)) {
            return in_array($permission, $manager->permissions, true);
        }


        return false;
    }
}