<?php

namespace Mnv\Core\Http;

use Mnv\Http\Exception\BadRequestException;

/**
 * это контейнер для пользовательских входных значений, таких как $_GET, $_POST, $_REQUEST, и $_COOKIE.
 */
final class InputBag extends ParameterBag
{
    /**
     * Возвращает скалярное входное значение по имени.
     *
     * @param string|int|float|bool|null $default The default value if the input key does not exist
     *
     * @return string|int|float|bool|null
     */
    public function get($key, $default = null)
    {
        $value = parent::get($key, $this);

        return $this === $value ? $default : $value;
    }

    /**
     * {@inheritdoc}
     */
    public function all($key = null)
    {
        return parent::all($key);
    }

    /**
     * Заменяет текущие входные значения новым набором.
     */
    public function replace($inputs = [])
    {
        $this->parameters = [];
        $this->add($inputs);
    }

    /**
     * Добавляет входные значения.
     */
    public function add($inputs = [])
    {
        foreach ($inputs as $input => $value) {
            $this->set($input, $value);
        }
    }

    /**
     * Задает ввод по имени.
     *
     * @param string|int|float|bool|array|null $value
     */
    public function set(string $key, $value)
    {
        $this->parameters[$key] = $value;
    }

    /**
     * @param string $key
     * @param null $default
     * @param int $filter
     * @param array $options
     * @return mixed
     */
    public function filter(string $key, $default = null, int $filter = \FILTER_DEFAULT, $options = [])
    {
        $value = $this->has($key) ? $this->all()[$key] : $default;

        // Always turn $options into an array - this allows filter_var option shortcuts.
        if (!\is_array($options) && $options) {
            $options = ['flags' => $options];
        }

        if (\is_array($value) && !(($options['flags'] ?? 0) & (\FILTER_REQUIRE_ARRAY | \FILTER_FORCE_ARRAY))) {

            if (!isset($options['flags'])) {
                $options['flags'] = \FILTER_REQUIRE_ARRAY;
            }
        }

        if ((\FILTER_CALLBACK & $filter) && !(($options['options'] ?? null) instanceof \Closure)) {
            throw new \InvalidArgumentException(sprintf('A Closure must be passed to "%s()" when FILTER_CALLBACK is used, "%s" given.', __METHOD__, $options['options'] ? $options['options'] : null));
        }

        return filter_var($value, $filter, $options);
    }
}
