<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class BannerGroups
 * @package Mnv\Models
 */
class BannerGroups extends Mnv
{

    private static $_table = 'banners_group';

    /** @var $groups */
    public $groups;

    /** @var $group */
    public $group;

    /** @var $groupId */
    public $groupId;

    /** @var $total */
    public $total;

    /**
     * BannersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Все группы со статусом `visible` для select
     * @return array
     */
    public function getGroups(): array
    {
        $groupSelects = array('' => lang('general:select'));
        if ($groups = DB::init()->connect()->table(self::$_table)->where('status', 'visible')->orderBy('orderBy')->indexKey('groupId')->getAllIndexes()) {
            foreach ($groups as $groupId => $group) {
                $groupSelects[$groupId] = $group->name;
            }
        }
        return $groupSelects;
    }

    public function getPageName($sectionId)
    {
        return DB::init()->connect()->table('sections')->select('name')->where('sectionId', $sectionId)->getValue();
    }
    /**
     * Все группы
     */
    public function listBanners(): void
    {
        $this->groups = DB::init()->connect()->table(self::$_table)->orderBy('orderBy')->indexKey('groupId')->getAllIndexes('array');

        $this->total();
    }

    /**
     * Кол-во групп
     */

    public function total(): void
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    /**
     * Редактировать группу
     */
    public function edit(): void
    {
        if (!empty($this->groupId)) {
            $this->group = DB::init()->connect()->table(self::$_table)->where('groupId', $this->groupId)->get('array');
            $this->group['pages'] = explode(',',  $this->group['pages']);
        }
    }


    /**
     * Новыя группа
     *
     * @param array|null $group
     * @return bool
     */
    public function add(?array $group): bool
    {
        $group['orderBy'] = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue() + 1;
        if ($this->groupId = DB::init()->connect()->table(self::$_table)->insert($group)) {
            return true;
        }

        return false;
    }

    /**
     * Обновление группы
     *
     * @param array|null $group
     * @return bool
     */
    public function update(?array $group): bool
    {
        if (!empty($this->groupId)) {
            DB::init()->connect()->table(self::$_table)->where('groupId', $this->groupId)->update($group);
            $this->edit();

            return true;
        }

        return false;
    }

    /**
     * Сортировка групп
     *
     * @param $groupIds
     */
    public function reorder($groupIds): void
    {
        $i = 0;
        foreach ($groupIds as $groupId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('groupId', $groupId)->update(['orderBy' => $i]);
        }
    }
    /**
     * Скрать / показать группу
     *
     * @return array
     */
    public function status(): array
    {
        if ($oldBannerStatus = DB::init()->connect()->table(static::$_table)->select('status')->where('groupId', $this->groupId)->getValue()) {
            $sliderUpdate['status'] = ($oldBannerStatus == 'visible') ? 'hidden' : 'visible';
            DB::init()->connect()->table(static::$_table)->where('groupId', $this->groupId)->update($sliderUpdate);
            return array('data' => true, 'status' => $sliderUpdate['status']);
        }

        return array('data' => false);
    }

    /**
     * удаление группы
     *
     * @return bool
     */
    public function remove(): bool
    {
        return !empty($this->groupId) && DB::init()->connect()->table(static::$_table)->where('groupId', $this->groupId)->delete();
    }

}