<?php

namespace Mnv\Models\Blocks;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Products
 * @package Mnv\Models\Contents
 */
class Blocks extends Mnv
{

    private static $_table = 'blocks';

    public $blockId;
    public $block;
    public $blocks;
    public $total;
    public $result;


    /**
     * фильтрация / сортировка контента
     *
     * @param array|null $filter
     */
    private function sorting(?array $filter): void
    {

        if (!empty($filter['query'])) {
            DB::init()->connect()->grouped(function($q) use ($filter) {
                $q->like('title', "%" . $filter['query'] . "%")->orLike('content', "%" . $filter['query'] . "%");
            });
        }
        if (!empty($filter['status'])) {
            DB::init()->connect()->where('status', $filter['status']);
        }
    }

    /**
     * Получение всех статей
     *
     * @param array|null $filter
     */
    public function getAll(?array $filter): void
    {
        $this->sorting($filter);

        $this->blocks = DB::init()->connect()->table(self::$_table)->select('*')->orderBy('blockId', 'DESC')->indexKey('blockId')->pagination($this->limit, $this->page)->getAllIndexes('array');
//         print_r(DB::init()->connect()->getQuery());

        /** Получение кол-во статей */
        $this->total($filter);
    }

    /**
     * Получение кол-во контента
     *
     * @param array|null $filter
     */
    public function total(?array $filter): void
    {
        /** фильтрация / сортировка */
        $this->sorting($filter);

        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Редактирование и добавление контента
     */
    public function edit(): void
    {
        $this->block = DB::init()->connect()->table(self::$_table)->where('blockId',  $this->blockId)->get('array');

    }

    /**
     * Добавление нового контента
     *
     * @param $block
     * @return bool
     */
    public function add($block): bool
    {
        /* insert новую запись и возвращаем ID */
        if ($this->blockId = DB::init()->connect()->table(self::$_table)->insert($block)) {
            return true;
        }

        return false;

    }

    /**
     * Обновление контента
     *
     * @param $block
     * @return bool
     */
    public function update($block): bool
    {
        return !empty($this->blockId) && DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->update($block);
    }


    /**
     * Удаление контента
     *
     * @return mixed|void
     */
    public function remove()
    {
        if (($this->blockId !== null) && DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->delete()) {
            return true;
        }
        return false;
    }

    /**
     * Изменение статуса
     */
    public function status(): bool
    {
        if ($this->blockId !== null) {
            $this->edit();
            if ($this->block !== null) {
                $blockUpdate['status'] = ($this->block['status'] == 'visible') ? 'hidden' : 'visible';
                if (DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->update($blockUpdate)) {
                    $this->result = array('data' => true, 'status' => $blockUpdate['status']);
                    return true;
                }

                return false;

            }

            return false;
        }

        return false;
    }




}