<?php

namespace Mnv\Models;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Core\Managers;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class Brands
 * @package Mnv\Models
 */
class Brands extends AdminMnv
{
    private static $_table   = 'brands';
    private static $_files   = 'files';
    private $_fields = array('brandId', 'name', 'url', 'publishedOn', 'orderBy', 'status');

    public $brand;
    public $brands;
    public $brandId;
    public $total;


    /**
     * @return array
     */
    public function getBrands(): array
    {
        $brandList = array();
        if ($brands = DB::init()->connect()->table('brands')->orderBy('name')->getAll()) {
            foreach ($brands as $key => $brand) {
                $letter = mb_substr(mb_strtolower($brand->name), 0, 1);
                $brandList[$letter][] = $brand;

            }
            ksort($brandList);
            //print_r($brandList);
        }
        return $brandList;
    }


    public function listBrand()
    {
        $this->brands = DB::init()->connect()->table(self::$_table)->select($this->_fields)->pagination($this->limit, $this->page)->orderBy('orderBy','ASC')->getAll('array');
        /** Получение кол-во статей */
        $this->total();
    }
    /**
     * Получение кол-во
     */
    public function total(): void
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Редактирование
     */
    public function edit()
    {
        if (!empty($this->brandId) && $this->brand = DB::init()->connect()->table(self::$_table)->select('*')->where('brandId', $this->brandId)->get('array')) {
            Managers::gettingInfoAboutUsers($this->brand);
            /** получение картинок контента */
            $this->getFiles();
        }
    }

    /**
     * Проверка на совпадение и получение fileName
     * @param $fileName
     */
    /**
     * @param $fileName
     * @return int|mixed|string|null
     */
    public function isFileName($fileName)
    {
        $fileName = strtolower($fileName);
        if (empty($fileName)) {
            $maxId = DB::init()->connect()->table(self::$_table)->max('brandId')->getValue();
            return $maxId ? $maxId + 1 : 1;
        }

        if (empty($this->brandId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('LOWER(fileName)', $fileName)->getValue()) {
                return $fileName;
            }
        } else if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('brandId','<>', $this->brandId)->where('LOWER(fileName)', $fileName)->getValue()) {
            return $fileName;
        }
        return null;
    }

    /**
     * Добавление нового контента
     *
     * @param array|null $brand
     * @param array|null $images
     * @param int $managerId
     * @return bool
     */
    public function add(?array $brand, ?array $images, int $managerId): bool
    {

        $maxId = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue();
        $brand['orderBy'] = $maxId ? $maxId + 1 : 1;

        $brand['addedBy']    = $managerId;
        $brand['addedOn']      = gmdate('Y-m-d H:i:s');
        $brand['modifiedBy']   = $managerId;
        $brand['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if ($this->brandId = DB::init()->connect()->table(self::$_table)->insert($brand)) {
            if (!empty($images['fileId'])) {
                $this->general($this->brandId, $images);
            }
            if (!empty($images['gallery'])) {
                $this->picture($this->brandId, array_keys($images['gallery']));
            }
            return true;
        }

        return false;
    }

    /**
     * Обновление контента
     *
     * @param array|null $brand
     * @param array|null $images
     * @param int $managerId
     * @return false
     */
    public function update(?array $brand, ?array $images, int $managerId): bool
    {

        if (!empty($this->brandId)) {
            unset($brand['addedBy']);
            unset($brand['addedOn']);

            $brand['modifiedBy']   = $managerId;
            $brand['modifiedOn']   = gmdate('Y-m-d H:i:s');

            DB::init()->connect()->table(self::$_table)->where('brandId',  $this->brandId)->update($brand);
            if (!empty($images['fileId'])) {
                $this->general($this->brandId, $images);
            }
            if (!empty($images['gallery'])) {
                $this->picture($this->brandId, array_keys($images['gallery']));
            }

            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * Удаление
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->delete()) {
            DB::init()->connect()->table('brand_images')->where('brandId', $this->brandId)->delete();
            return true;
        }

        return false;
    }

    /**
     * Статус
     *
     * @return array
     */
    public function status(): array
    {
        $oldBrandStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('brandId',  $this->brandId)->getValue();
        $brandUpdate['status'] = ($oldBrandStatus== 'visible') ? 'hidden' : 'visible';

        if (DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->update($brandUpdate)) {
            return  array('data' => true, 'status' => $brandUpdate['status']);
        }
        return array('data' => false);

    }
    /**
     * Утверждение
     * @return bool
     */
    public function approve(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->update(['status' => 'visible'])) {
            return true;
        }

       return false;

    }

    /**
     * Сортировка товара
     * @param $ids
     * @param $brandIds
     */
    public function reorderBrand($ids, $brandIds)
    {
        foreach ($brandIds as $i => $brandId) {
//           print_r( $ids[$i] . '-' . $brandId . ' : ');
            DB::init()->connect()->table(self::$_table)->where('brandId', '=', $ids[$i])->update(['orderBy' => $brandId]);
        }

    }

//    /**
//     * Удаление основной картинки
//     * @param $brandId
//     * @return bool
//     */
//    public function deleteImage($brandId): bool
//    {
//        if (!empty($brandId)) {
//            DB::init()->connect()->table(self::$_table)->where('brandId', $brandId)->update(['fileId' => 0]);
//            return true;
//        }
//
//        return false;
//    }

    /**
     * Удаление основной картинки
     * @param int|null $imageId
     * @return bool
     */
    public function deleteImage(?int $imageId): bool
    {
        if ($imageId !== null) {
            DB::init()->connect()->table('brand_images')->where('imageId', $imageId)->delete();
            return true;
        }

        return false;
    }


    /**
     * Добавление или замена информации у картинки в галереи
     *
     * @param $imageId
     * @param $picture
     * @return array|false|int
     */
    public function editPictureInfo($imageId, $picture)
    {
        $updateParams = [
            'title'         => $picture['title'],
            'alias'         => $picture['alias'],
            'description'   => $picture['description'],
            'link'          => $picture['link'],
            'position'      => $picture['position']
        ];
        if (DB::init()->connect()->table('brand_images')->where('imageId', $imageId)->update($updateParams)) {
            return DB::init()->connect()->table('brand_images')->where('imageId', $imageId)->get();
        }
        return false;
    }

    /**
     * Сортировка картинок в галереи
     * @param $imageIds
     * @return bool
     */
    public function sortPictures($imageIds): bool
    {
        $order = 1;
        foreach ($imageIds as  $imageId) {
            DB::init()->connect()->table('brand_images')->where('imageId', $imageId)->update(['orderBy' => $order]);
            $order++;
        }
        return true;
    }

    /**
     * Удаление картинки из галереи
     * @param $imageId
     * @return bool
     */
    public function deletePicture($imageId): bool
    {
        if (DB::init()->connect()->table('brand_images')->where('imageId', $imageId)->delete()) {
            return true;
        }

        return false;
    }

    /**
     * Добавление основной картинки к контенту
     *
     * @param $brandId
     * @param $images
     * @return bool
     */
    protected function general($brandId, $images): bool
    {
        $imageUpload = array_filter([
            'brandId' => $brandId,
            'fileId' => $images['fileId'],
            'type' => 'general',
            'orderBy' => 0
        ]);

        if ($imageId = DB::init()->connect()->table('brand_images')->select('imageId')->where('type','general')->where('brandId', $brandId)->getValue()) {
            $imageUpload['imageId'] = $imageId;
        }

        if (DB::init()->connect()->table('brand_images')->replace($imageUpload)) {
            return true;
        }

        return false;
    }

    /**
     * Загрузка картинок в галерею
     *
     * @param $brandId
     * @param $images
     */
    protected function picture($brandId, $images): void
    {
        $idx = 0;
        if ($order = DB::init()->connect()->table('brand_images')->max('orderBy')->where('brandId', $brandId)->getValue()) {
            $idx = $order;
        }

        foreach ($images as $fileId) {
            $idx++;
            $imageUpload = array_filter([
                'brandId'   => $brandId,
                'fileId'    => $fileId,
                'type'      => 'gallery',
                'orderBy'    => $idx
            ]);
            DB::init()->connect()->table('brand_images')->replace($imageUpload);
        }
    }

    /**
     * получать основной картинки
     */
    protected function getFiles(): void
    {
        if (!empty($this->brandId) && $images = DB::init()->connect()->table('brand_images')->select('*')->where('brandId', $this->brandId)->indexKey('imageId')->orderBy('orderBy')->getAllIndexes()) {
            foreach ($images as $imageId => $image) {
                if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $image->fileId)->get()) {
                    if ($image->type === 'general') {
                        $this->brand['image'] = ImageSizes::init()->get($image, $file);

                    } elseif ($image->type === 'gallery') {
                        $this->brand['gallery'][$imageId] = ImageSizes::init()->get($image, $file);
                    }
                }
            }
        }
    }

    /**
     * получать основной картинки
     *
     * @param $brandId
     * @return ImageSizes|null
     */
    public function getFile($brandId)
    {
        $articleImage = DB::init()->connect()->table('brand_images')->select('fileId')->where('type', 'general')->where('brandId', $brandId)->get();
        if ($articleImage && $file = DB::init()->connect()->table(self::$_files)->select('*')->where('fileId', $articleImage->fileId)->get()) {
            return ImageSizes::init()->get($articleImage, $file);
        }

        return null;
    }

}