<?php

namespace Mnv\Models\Contents;

/**
 * Interface ContentInterface
 * @package Mnv\Models\Contents
 */
interface ContentInterface
{
    /**
     * Получить весь контент
     *
     * @param array|null $filter
     * @param $orderBy
     * @return mixed
     */
    public function listContent(?array $filter, $orderBy): void;

    /**
     * Получить кол-во контента
     *
     * @param array|null $filter
     * @param $manager
     * @return mixed
     */
    public function total(?array $filter, $manager): void;

    /**
     * Удаление контента
     *
     * @param $manager
     * @return mixed
     */
    public function remove();

    /**
     * Обновление статуса контента
     *
     * @param $manager
     * @return mixed
     */
    public function approve($manager);

    /**
     * Редактирование контента
     *
     * @return mixed
     */
    public function edit();

    /**
     * Добавление нового контента
     *
     * @param $content
     * @param $images
     * @param $manager
     * @return mixed
     */
    public function add($content, $images, $manager);

    /**
     * Обновление контента
     *
     * @param $content
     * @param $images
     * @param $manager
     * @return mixed
     */
    public function update($content, $images, $manager);
}