<?php

namespace Mnv\Models;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;

/**
 * Class Coupons
 * @package Mnv\Models
 */
class Coupons extends AdminMnv
{

    private static $_table  = 'coupons';

    public $coupon;
    public $couponId;
    public $coupons;
    public $total;

    /**
     * SlidersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }


    protected function getAll(): void
    {
        $this->coupons = DB::init()->connect()->table(static::$_table)->orderBy('couponId', 'DESC')->getAll('array');

        $this->total();
    }


    private function total()
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }


    protected function edit(): void
    {
        if (!empty($this->couponId)) {
           $this->coupon = DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->get('array');
        }
    }

    /**
     * Новый
     *
     * @param array $coupon
     * @return bool
     */
    protected function add(array $coupon): bool
    {
//        print_r($coupon);
        if ($this->couponId = DB::init()->connect()->table(static::$_table)->insert($coupon)) return true;

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param array $coupon
     * @return bool
     */
    protected function update(array $coupon): bool
    {
        if (!empty($this->couponId)) {
            DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->update($coupon);
            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $couponIds
     */
    protected function reorder($couponIds): void
    {
        $i = 0;
        foreach ($couponIds as $couponId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('couponId', $couponId)->update(['orderBy' => $i]);
        }
    }
    /**
     * Скрать / показать
     *
     * @return array
     */
    protected function status(): array
    {
        if (!empty($this->couponId)) {
            if ($oldCouponStatus = DB::init()->connect()->table(static::$_table)->select('status')->where('couponId', $this->couponId)->getValue()) {
                $sliderUpdate['status'] = ($oldCouponStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->update($sliderUpdate);
                return array('data' => true, 'status' => $sliderUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }


    /**
     * удаление слайда
     *
     * @return bool
     */
    protected function remove(): bool
    {
        return !empty($this->couponId) && DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->delete();
    }

}