<?php

namespace Mnv\Models;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;

/**
 * Class FAQ
 * @package Mnv\Models
 */
class FAQ extends AdminMnv
{
    /** @var string  */
    private static $_table  = 'faq';

    /** @var $faqs */
    public $faqs;
    /** @var $faq */
    public $faq;
    /** @var int  */
    public int $faqId;
    /** @var int  */
    public int $total;

    /** все */
    protected function getAll(): void
    {
        $this->faqs = DB::init()->connect()->table(static::$_table)->orderBy('orderBy')->getAll('array');

        $this->total();
    }

    /** кол-во */
    private function total(): void
    {
        $this->total = (int)DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }

    /** Редактирование */
    protected function edit(): void
    {
        if (!empty($this->faqId)) {
            $this->faq = DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->get('array');
        }
    }


    /**
     * Создание нового
     * @param array|null $faq
     * @return bool
     */
    protected function add(?array $faq): bool
    {
        $faq['orderBy'] = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue() + 1;
        if ($this->faqId = (int)DB::init()->connect()->table(self::$_table)->insert($faq)) {
            return true;
        }

        return false;
    }

    /**
     * Обновление
     *
     * @param array|null $faq
     * @return bool
     */
    protected function update(?array $faq): bool
    {
        if (!empty($this->faqId)) {
            DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->update($faq);
            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * Сортировка
     * @param $faqIds
     */
    protected function reorder($faqIds): void
    {
        $i = 0;
        foreach ($faqIds as $faqId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('faqId', $faqId)->update(['orderBy' => $i]);
        }

    }
    /**
     * Скрать / показать
     * @return array
     */
    protected function status(): array
    {
        if (!empty($this->faqId)) {
            if ($oldFaqStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('faqId', $this->faqId)->getValue()) {
                $faqUpdate['status'] = ($oldFaqStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('faqId', $this->faqId)->update($faqUpdate);
                return array('data' => true, 'status' => $faqUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }


    /**
     * удаление
     * @return bool
     */
    protected function remove(): bool
    {
        return !empty($this->faqId) && DB::init()->connect()->table(self::$_table)->where('faqId', $this->faqId)->delete();
    }

}