<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Features
 * @package Mnv\Models
 */
class Features extends Mnv
{

    private static $_table   = 'product_features';

    public $feature;
    public $features;
    public $featureId;
    public $total;

    public $sectionIds;

    public function getAllProductFeatures(?int $sectionId)
    {
        if (!empty($sectionId)) DB::init()->connect()->like('sectionIds', "%$sectionId%");

        return DB::init()->connect()->table(self::$_table)->select('id, name, fileName')->where('status', 'visible')->orderBy('orderBy ')->getAll('array');
    }


    public function getAllProductFeatureIds(?int $sectionId)
    {
        if (!empty($sectionId)) DB::init()->connect()->like('sectionIds', "%$sectionId%");
        return DB::init()->connect()->table(self::$_table)->select('id')->where('status', 'visible')->orderBy('orderBy')->indexKey('id')->valueKey('id')->getAllIndexes('array');
    }


    private function sorting(?array $filter): void
    {
        if (!empty($filter['query'])) {
            DB::init()->connect()->grouped(function($q) use ($filter) {
                $q->like('name', "%" . $filter['query'] . "%");
            });
        }
        if (!empty($filter['status'])) {
            DB::init()->connect()->where('status', $filter['status']);
        }
        if (!empty($filter['sectionIds'])) {
            DB::init()->connect()->grouped(function($q) use ($filter) {
                foreach ($filter['sectionIds'] as $key => $sectionId) {
                    if ($key === array_key_first($filter['sectionIds'])) {
                        $q->like('sectionIds', "%" . $sectionId . "%");
                    } else {
                        $q->orLike('sectionIds', "%" . $sectionId . "%");
                    }
                }
            });
        }
    }

    public function getAll(?array $filter, $orderBy): void
    {
        $this->sorting($filter);
        $this->features = DB::init()->connect()->table(self::$_table)->select('*')->orderBy($orderBy)->pagination($this->limit, $this->page)->getAll('array');

        $this->total($filter);
    }

    public function total(?array $filter): void
    {
        $this->sorting($filter);
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    /**
     * @param string $name
     * @return mixed|string|null
     */
    public function existsFeature(string $name)
    {
        return DB::init()->connect()->table(self::$_table)->select('id')->where('name', $name)->getValue();

    }

    /**
     * TODO Сделано
     * Редактирование/добавление
     */
    public function edit(): void
    {
        if (!empty($this->featureId)) {
           $this->feature = DB::init()->connect()->table(self::$_table)->where('id', $this->featureId)->get('array');
        }
    }

    /**
     * @param array $feature
     * @return bool
     */
    public function add(array $feature): bool
    {
        $feature['orderBy'] = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue() + 1;
        if ($this->featureId = DB::init()->connect()->table(self::$_table)->insert($feature)) {
            return true;
        }

        return false;
    }

    /**
     * @param array $feature
     * @return bool
     */
    public function update(array $feature): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $this->featureId)->update($feature)) {
            return true;
        }

        return false;
    }

    /**
     * Удаление
     *
     * @param $featureId
     * @return bool
     */
    public function remove($featureId): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $featureId)->delete()) {
            DB::init()->connect()->table('product_options')->where('featureId', $featureId)->delete();
            return true;
        }

        return false;
    }

    public function status(): array
    {
        if (!empty($this->featureId)) {
            if ($oldFeatureStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('id', $this->featureId)->getValue()) {
                $featureUpdate['status'] = ($oldFeatureStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('id', $this->featureId)->update($featureUpdate);
                return array('data' => true, 'status' => $featureUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }

    /**
     * Сортировка
     *
     * @param $featureIds
     */
    public function reorder($featureIds): void
    {
        $i = 0;
        foreach ($featureIds as $featureId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('id', $featureId)->update(['orderBy' => $i]);
        }
    }


    /**
     * @param array $feature
     * @return int|null
     */
    public function addFeature(array $feature): ?int
    {
        $feature['orderBy'] = DB::init()->connect()->table('product_features')->max('orderBy')->getValue() + 1;
        if ($featureId = DB::init()->connect()->table('product_features')->insert($feature)) {
            return $featureId;
        }

        return null;
    }


    /** OPTIONS */

    public function convertOption($options)
    {
        $productOption = array();
        if (is_array($options)) {
            foreach($options as $featureId => $value) {
                $productOption[$featureId] = new \stdClass;
                $productOption[$featureId]->featureId = $featureId;
                $productOption[$featureId]->value = $value;
            }
            return $productOption;
        }
    }

    public function getOptions($productId)
    {
        return DB::init()->connect()->table('product_options')
            ->select('productId, featureId, value')
            ->where('productId', $productId)->indexKey('featureId')->getAllIndexes();

    }

    /**
     * Обновление/вставка свойства
     *
     * @param int|null $productId
     * @param int|null $featureId
     * @param $value
     * @param $icon
     */
    public function updateOption(?int $productId, ?int $featureId, $value , $icon)
    {
        if ($value != '') {
            DB::init()->connect()->table('product_options')->select('*')->replace([
                'productId' => $productId,
                'featureId' => $featureId,
                'value' => $value,
                'icon' => $icon
            ]);
        } else {
            $this->deleteOption($productId, $featureId);
        }
    }

    /**
     * Удаление свойства
     *
     * @param int|null $productId
     * @param int|null $featureId
     */
    public function deleteOption(?int $productId, ?int $featureId)
    {
        DB::init()->connect()->table('product_options')->where('productId', $productId)->where('featureId', $featureId)->delete();
    }

    /**
     * Получить все свойства
     *
     * @param $productId
     * @return array|mixed|null
     */
    public function getProductOptions($productId)
    {
        return DB::init()->connect()->table('product_options')
            ->join('product_features', 'id', '=', 'featureId')
            ->select('productId, featureId, name, value, icon, orderBy')
            ->where('productId', $productId)
            ->where('status', 'visible')
            ->orderBy('orderBy')
            ->indexKey('featureId')->getAllIndexes('array');
    }

    /**
     * Получить `value` свойства
     *
     * @param $featureId
     * @return mixed|string|null
     */
    public function getProductFeatureValue($featureId)
    {
        return DB::init()->connect()->table('product_options')->select('value')->where('featureId', $featureId)->getValue();
    }

}