<?php

namespace Mnv\Models;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;

/**
 * Class Maps
 * @package Mnv\Models
 */
class Maps extends AdminMnv
{

    private static $_table = 'maps';

    public $map;

    protected function getMaps(): void
    {
        $this->map = DB::init()->connect()->table(self::$_table)->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes('array');
    }

    /**
     * @param $map
     * @return bool
     */
    protected function save($map): bool
    {
        foreach ($map as $codename => $value) {
            $data = [
                'codename'  => $codename,
                'value'     => $value,
            ];

            DB::init()->connect()->table( self::$_table)->replace($data);
        }
        return true;
    }



}