<?php

namespace Mnv\Models\Sections;


use Mnv\Core\DB;
use Mnv\Core\Managers;

/**
 * Class Sections
 * @package System
 */
class Sections extends SectionAbstract
{
    private static $_table          = 'sections';
    private static $_table_images   = 'section_images';
    private static $_table_articles = 'articles';
    private static $_table_comments = 'comments';

    private $fields = array('sectionId, parentId, sortOrder, name, alias, topMenu, fileName, url, status, typeContent, type');

    /**
     * Получение всех разделов
     */
    protected function listSections(): void
    {
        $this->sections = DB::init()->connect()->table(self::$_table)->select($this->fields)->orderBy('sortOrder', 'asc')->where('parentId', $this->parentId)->pagination($this->limit, $this->page)->getAll('array');


        $this->total();
    }

    /**
     * Получение кол-во разделов
     */
    protected function total(): void
    {
        $this->total = (int)DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $this->parentId)->getValue();
    }

    /**
     * Получить раздел
     */
    protected function get(): void
    {
        $this->section = DB::init()->connect()->table(self::$_table)->where('sectionId', $this->sectionId)->get('array');
    }

    /**
     * Редактирование и добавление раздела
     */
    protected function edit(): void
    {
        if (!empty($this->sectionId)){
            /** получение раздела */
            $this->get();
            /** получать информацию о пользователе, который создал или редактировал раздела */
            Managers::gettingInfoAboutUsers($this->section);
            /** получение картинок раздела */
            $this->getFiles();
        }
    }

    /**
     * Проверка fileName на совпадение главной страницы
     *
     * @param string $fileName
     * @return string|null
     */
    public function isFileNamePage(string $fileName): ?string
    {
        if (empty($this->sectionId)) {
            if ($fileName = (string)DB::init()->connect()->table(self::$_table)->select('fileName')->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
                return $fileName;
            }
        } else if ($fileName = (string)DB::init()->connect()->table(self::$_table)->select('fileName')->where('sectionId','<>', $this->sectionId)->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
            return $fileName;
        }

        return null;
    }
    /**
     * Проверка на совпадение `fileName` и получение `fileName`
     *
     * @param string $fileName
     * @return string|null
     */
    public function isFileNameSection(string $fileName): ?string
    {
        $fileName = strtolower($fileName);
        if (empty($this->sectionId)) {
            if ($fileName =(string) DB::init()->connect()->table(self::$_table)->select('fileName')->where('parentId', $this->parentId)->where('LOWER(fileName)', $fileName)->getValue()) {
                return $fileName;
            }
        } else if ($fileName = (string)DB::init()->connect()->table(self::$_table)->select('fileName')->where('sectionId','<>', $this->sectionId)->where('parentId', $this->parentId)->where('LOWER(fileName)', $fileName)->getValue()) {
            return $fileName;
        }

        return null;
    }

    protected function getParentId(): void
    {
        if (!empty($this->parentId) && !DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $this->parentId)->getValue()) {
            $this->parentId = (int)DB::init()->connect()->table(self::$_table)->select('parentId')->where('sectionId', $this->parentId)->getValue();
        }
    }

//    /**
//     * Проверка, существует ли у раздела подразделы или статьи
//     * @param $sectionId
//     * @param $type
//     * @return bool
//     */
//    public function isSectionType($sectionId, $type)
//    {
//        if ($type == 'plain') {
//            if (DB::init()->connect()->table(self::$_table)->select('sectionId')->where('parentId', $sectionId)->getValue()) {
//                return false;
//            }
//            if (DB::init()->connect()->table(self::$_table_articles)->select('sectionId')->where('sectionId','=', $sectionId)->getValue()) return false;
//        }
//        return true;
//    }
//    /**
//     * TODO работает / но проверить еще раз
//     * Проверка тип подраздела у основного раздела
//     * @param $parentId
//     * @return int|null
//     */
//    public function parentTypeContent($parentId)
//    {
//        if ($parentTypeContent = DB::init()->connect()->table(self::$_table)->select('typeContent, type')->where('sectionId','=', $parentId)->get()) {
//            return $parentTypeContent;
//        }
//
//        return null;
//    }
    /**
     * Добавить новый раздел
     *
     * @param array $section
     * @param array|null $images
     * @param int $managerId
     * @return bool
     */
    protected function add(array $section, ?array $images, int $managerId): bool
    {

        $section['url']        = '';
        $section['addedBy']    = $managerId;
        $section['addedOn']    = gmdate('Y-m-d H:i:s');
        $section['modifiedBy'] = $managerId;
        $section['modifiedOn'] = gmdate('Y-m-d H:i:s');
        $section['sortOrder']  = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $section['parentId'])->getValue() + 1;

        if ($this->sectionId = (int)DB::init()->connect()->table(self::$_table)->insert($section)) {

            if (!empty($images['fileId'])) {
                $this->general($this->sectionId, $images);
            }
            if (!empty($images['gallery'])) {
                $this->picture($this->sectionId, $images);
            }
            if (!empty($images['docs'])) {
                $this->docs($this->sectionId, $images);
            }

            $this->edit();

            return true;
        }
        return false;
    }
    /**
     * Обновление информации раздела
     *
     * @param array $section
     * @param $oldSection
     * @param array|null $images
     * @param int $managerId
     * @return bool
     */
    protected function update(array $section, $oldSection, ?array $images, int $managerId): bool
    {

        if (isset($oldSection['parentId']) && (int)$section['parentId'] !== (int)$oldSection['parentId']) {
            /** изменить порядок сортировки, если был изменен родитель */
            $section['sortOrder']  = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $section['parentId'])->getValue() + 1;
        }
        $section['modifiedBy'] = $managerId;
        $section['modifiedOn'] = gmdate('Y-m-d H:i:s');

        if (!empty($images['fileId'])) {
            $this->general($this->sectionId, $images);
        }
        if (!empty($images['gallery'])) {
            $this->picture($this->sectionId, $images);
        }
        if (!empty($images['docs'])) {
            $this->docs($this->sectionId, $images);
        }

        if (DB::init()->connect()->table(self::$_table)->where('sectionId',  $this->sectionId)->update($section)) {

            $this->edit();

            return true;
        }

        return false;
    }


    /**
     * Проверить сущестуют ли у этого раздела подразделы и контент
     * @param int $sectionId
     */
    /**
     * @return false
     */
    protected function confirmDelete(): bool
    {
        if (!empty($this->sectionId)) {
            $this->get();
            if ($this->section) {
                /* проверки, если раздел имеет подразделы */
                $this->section['hasSubsections'] = DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $this->sectionId)->getValue();
                /* проверки, если раздел имеет статьи */
                $this->section['hasArticles'] = DB::init()->connect()->table(self::$_table_articles)->count('*', 'count')->where('sectionId', $this->sectionId)->getValue();

            return true;
            }

        }

        return false;
    }
    /**
     * Удаление, удаление или перемещение подразделов и контент
     *
     * @param $param
     * @return bool
     */
    protected function deleteConfirmed($param): bool
    {
        $this->get();
        if ($this->section) {
            /** обработка контента */
            if (isset($param['moveArticlesTo'])) {
                if ($param['moveArticlesTo'] == 'delete') {
                    /** удаление контент, удаляемого раздела */
                    $this->delete_contents(['sectionId' => $this->sectionId]);
                } else {
                    /** перемещение контент, удаляемого раздела */
                    $this->move_content($this->section['sectionId'], $param);
                }
            }

            /** обработка подразделов */
            if (isset($param['moveSubsectionsTo'])) {
                if ($param['moveSubsectionsTo'] == 'delete') {
                    /** удаление раздела и его контент */
                    $this->delete_sections($this->section['sectionId']);
                } else {
                    /** переместить подразделы  */
                    $this->reorder_section($this->section['sectionId'], $param);
                }
            }

            /** Работает удаление изображения вместе с удалением раздела удаляет из базы данных */
            DB::init()->connect()->table(self::$_table_images)->where('sectionId', $this->sectionId)->delete();

            /** удаление раздела */
            DB::init()->connect()->table(self::$_table)->where('sectionId', $this->sectionId)->delete();
            $this->writeSortOrders($this->parentId);

            return true;
        }

        return false;
    }

    /**
     * Перемещение подраздела(ов) в существующий раздел
     *
     * @param int $sectionId
     * @param $param
     * @return void
     */
    private function reorder_section(int $sectionId, $param): void
    {
        if ($destSectionId = DB::init()->connect()->table(self::$_table)->select('sectionId')->where('sectionId', $param['moveSubsectionsTo'])->getValue()) {
            $maxSortOrder = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $destSectionId)->getValue();

            DB::init()->connect()->table(self::$_table)->where('parentId',  $sectionId)->update([
                'sortOrder' => (int)($maxSortOrder + 1),
                'parentId' => $destSectionId
            ]);

            $this->writeSortOrders($destSectionId);

            return;
        }

        if ($hasSubsections =  DB::init()->connect()->table(self::$_table)->where('parentId', $sectionId)->getAll('array')) {
            foreach ($hasSubsections as $hasSubsection) {
                DB::init()->connect()->table(self::$_table)->where('parentId', $hasSubsection['parentId'])->update([
                    'sortOrder' => $hasSubsection['sectionId'],
                    'parentId' => 0
                ]);
            }
        }
    }

    /**
     * Удаление разлела и его контент
     * @param int $sectionId
     * @return void
     */
    private function delete_sections(int $sectionId): void
    {
        global $SECTIONS;

        if (!empty($SECTIONS[$sectionId]['allChildren'])) {
            DB::init()->connect()->table(self::$_table)->in('sectionId', $SECTIONS[$sectionId]['allChildren'])->delete();
            DB::init()->connect()->table(self::$_table_images)->in('sectionId', $SECTIONS[$sectionId]['allChildren'])->delete();

            $this->delete_contents($SECTIONS[$sectionId]['allChildren']);
        }
    }

    /**
     * Сортировка разделов
     *
     * @param $ids
     * @param $sectionIds
     * @return bool
     */
    protected function reorderSections($ids, $sectionIds): bool
    {
        foreach ($sectionIds as $i => $sectionId) {
            DB::init()->connect()->table(self::$_table)->where('sectionId', $ids[$i])->update([
                'sortOrder' => $sectionId
            ]);
        }
        return true;
    }
    /**
     * Сортировка при изменение раздела
     *
     * @param int $parentId
     */
    protected function writeSortOrders(int $parentId = 0): void
    {
        $sections = DB::init()->connect()->table(self::$_table)->select('sectionId, sortOrder')->where('parentId', $parentId)->orderBy('sortOrder')->getAll('array');
        $sortOrder = 0;
        foreach ($sections as $section) {
            $sortOrder++;
            if ((int)$section['sortOrder'] !== $sortOrder) {
                DB::init()->connect()->table(self::$_table)->where('sectionId', $section['sectionId'])->update([
                    'sortOrder'=> $sortOrder
                ]);
            }
        }
    }
    /**
     * Удаление контента и комментарии контента
     *
     * @param $sectionIds
     */
    private function delete_contents($sectionIds): void
    {
        DB::init()->connect()->in('sectionId', $sectionIds);
        $articles = DB::init()->connect()->table(self::$_table_articles)->select('articleId')->getAll('array');

        foreach ($articles as $article) {
            DB::init()->connect()->table(self::$_table_articles)->where('articleId', $article['articleId'])->delete();
            DB::init()->connect()->table(self::$_table_comments)->where('articleId', $article['articleId'])->delete();
        }
    }

    /**
     * Перемещение контента
     *
     * @param int $sectionId
     * @param $param
     */
    private function move_content(int $sectionId, $param): void
    {
        global $SECTIONS, $databaseConfig;

        DB::init()->connect()->query("UPDATE `" . $databaseConfig['prefix'].self::$_table_articles . "` 
            SET `url` = CONCAT('". $SECTIONS[$param['moveArticlesTo']]['path'] . "', '/', `fileName`, '.". $this->config['file_extension']."'), `sectionId` = $param[moveArticlesTo] 
            WHERE `sectionId` = '$sectionId'")->exec();
    }

    /**
     * Добавить / удалить с главного меню
     */
    public function menuSection(): bool
    {
        $topMenu = (int)DB::init()->connect()->table(self::$_table)->select('topMenu')->where('sectionId',  $this->sectionId)->getValue();
        $sectionUpdate['topMenu'] = ($topMenu === 0) ? 1 : 0;

        if ($this->updateSectionParams($sectionUpdate)) {
            $this->result = array('data' => true, 'check' => $sectionUpdate['topMenu']);

            return true;
        }

        $this->result = array('data' => false, 'check' => false);

        return false;
    }

    /**
     * Скрыть / показать раздел
     *
     * @return array
     */
    public function statusSection(): array
    {
        $oldStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('sectionId', $this->sectionId)->getValue();
        $sectionUpdate['status'] = ($oldStatus == 'visible') ? 'hidden' : 'visible';

        if ($this->updateSectionParams($sectionUpdate)) {
            return array('data' => true, 'status' => $sectionUpdate['status']);
        }

        return array('data' => false);
    }


    /**
     * @param $sectionUpdate
     * @return bool
     */
    private function updateSectionParams($sectionUpdate): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('sectionId', $this->sectionId)->update($sectionUpdate)) {
            return true;
        }
        return false;
    }


    /**
     * Удаление основной картинки
     * @param $imageId
     * @return bool
     */
    public function deleteImage($imageId): bool
    {

        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->delete()) {
            return true;
        }

        return false;
    }

    /**
     * Добавление или замена информации у картинки в галереи
     * @param $imageId
     * @param $picture
     * @return bool|int
     */
    public function editPictureInfo($imageId, $picture)
    {
        $updateParams = [
            'title'         => $picture['title'],
            'alias'         => $picture['alias'],
            'description'   => $picture['description'],
            'link'          => $picture['link'],
            'position'      => $picture['position']
        ];
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->update($updateParams)) {
            return DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->get();
        }

        return false;
    }


    /**
     * Сортировка картинок в галереи
     * @param $imageIds
     * @return bool
     */
    public function sortPictures($imageIds): bool
    {
        $order = 1;
        foreach ($imageIds as  $imageId) {
            DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->update([
                'orderBy'=> $order
            ]);
            $order++;
        }
        return true;
    }


    /**
     * Удаление картинки из галереи
     * @param $imageId
     * @return bool
     */
    public function deletePicture($imageId): bool
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId',  $imageId)->delete()) {
            return true;
        }

        return false;
    }



    /**
     * Удаление картинки из галереи
     * @param $imageId
     * @return bool
     */
    public function deleteDocs($imageId): bool
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId',  $imageId)->delete()) {
            return true;
        }

        return false;
    }





}