<?php


namespace Mnv\Models\Users;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;

class UserGroups extends AdminMnv
{
    private static $_table = 'user_group';
    private static $_table_privileges = 'user_group_privileges';


    public $groups;
    public $group;
    public $privileges;
    public $groupId;

    public static function selectGroup($userType)
    {
        $group = array('' => "Выберите группу" );
        if ($userType == UserTypes::ADMIN) DB::init()->connect()->notWhere('usergroup_id', 1);
        $group += DB::init()->connect()->table(self::$_table)->select('usergroup_id, groupName')->where('status', 'visible')->indexKey('usergroup_id')->valueKey('groupName')->getAllIndexes();
        return $group;
    }

    public static function arrayGroup()
    {
        return DB::init()->connect()->table(self::$_table)->select('usergroup_id')->where('status', 'visible')->indexKey('usergroup_id')->valueKey('usergroup_id')->getAllIndexes();
    }


    /**
     * @param $groupId
     * @return string|null
     */
    public static function accessLevelName($groupId): ?string
    {
        return DB::init()->connect()->table('user_group')->select('groupName')->where('usergroup_id', $groupId)->getValue();
    }

    public function listGroup($manager)
    {
        if ($manager->userType == UserTypes::ADMIN) DB::init()->connect()->notWhere('usergroup_id', 1);
        $this->groups = DB::init()->connect()->table(self::$_table)->select('usergroup_id AS groupId, groupName, status')->getAll('array');
    }

    /**
     * Получить пользователя
     */
    public function edit(): void
    {
        $this->group = DB::init()->connect()->table(self::$_table)->where('usergroup_id', $this->groupId)->get('array');
        if (!empty($this->group)) {
            $this->group['privilege'] = DB::init()->connect()->table(self::$_table_privileges)->select('privilege')->where('usergroup_id', $this->groupId)->valueKey('privilege')->getAllIndexes();
        }

//        print_r($this->group);
    }


    /**
     * @param $groupName
     * @return mixed|string|null
     */
    public function checkExistenceGroupName($groupName): ?string
    {

        if (empty($this->groupId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('groupName')->where('LOWER(groupName)', $groupName)->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('groupName')->where('usergroup_id','<>', $this->groupId)->where('LOWER(groupName)', $groupName)->getValue()) return $fileName;
        }

        return null;
    }

    /**
     * Добавление нового пользователя
     *
     * @return bool
     */
    public function add(?array $group) : bool
    {
        if ($this->groupId = DB::init()->connect()->table(self::$_table)->insert((array)$group)) {
            $this->privileges();
            return true;
        }

        return false;
    }

    /**
     * Изменение данных пользователя
     */
    public function update(?array $group): void
    {
        DB::init()->connect()->table(self::$_table)->where('usergroup_id', $this->groupId)->update($group);
        $this->privileges();

    }

    public function remove(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('usergroup_id', $this->groupId)->delete()) {
            DB::init()->connect()->table(self::$_table_privileges)->where('usergroup_id', $this->groupId)->delete();
            return true;
        }
        return false;
    }

    private function privileges(): void
    {
        DB::init()->connect()->table(self::$_table_privileges)->where('usergroup_id', $this->groupId)->delete();

        foreach ($this->privileges as $privilege) {
            DB::init()->connect()->table(self::$_table_privileges)->insert([
                'usergroup_id'   => $this->groupId,
                'privilege'      => $privilege
            ]);
        }
    }

    public function status(): array
    {
        if (!empty($this->groupId)) {
            if ($oldGroupStatus = DB::init()->connect()->table(self::$_table)->select('status')->where('usergroup_id', $this->groupId)->getValue()) {
                $update['status'] = ($oldGroupStatus == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('usergroup_id', $this->groupId)->update($update);
                return array('data' => true, 'status' => $update['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }

}