<?php

namespace Mnv\Models\Users;


/**
 * Interface UserInterface
 * @package Mnv\Models\Users
 */
interface UserInterface
{

    /**
     * Получить пользователей
     *
     * @param string|null $query  (optional)
     * @param string|null $status  (optional)
     * @param string|null $orderBy  (optional)
     * @param $userTypes
     * @param $manager
     */
    public function getAll(?string $query, ?string $status, ?string $orderBy, $userTypes, $manager = null): void;

    /**
     * Получить кол-во пользователей
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param $manager
     * @return mixed
     */
    public function total(?string $query, ?string $status, $userTypes, $manager = null): void;


    /**
     * Удаление пользователя
     */
    public function remove(?string $userType);

    /**
     * Обновление статуса пользователя
     */
    public function approve();

    /**
     * Редактирование пользователя
     *
     * @return mixed
     */
    public function edit(?string $userType);

    /**
     * Добавление нового пользователя
     *
     * @param array|null $user
     * @param int $managerId
     * @return mixed
     */
    public function add(?array $user, int $managerId);

    /**
     * Обновление пользователя
     *
     * @param array|null $user
     * @param int $managerId
     * @return mixed
     */
    public function update(?array $user, int $managerId);



}